package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Service} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceAssert<S extends AbstractServiceAssert<S, A>, A extends Service> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceAssert}</code> to make assertions on actual Service.
   * @param actual the Service we want to make assertions on.
   */
  protected AbstractServiceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Service's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Service's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual Service's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual Service's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's containerPort is equal to the given one.
   * @param containerPort the given containerPort to compare the actual Service's containerPort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's containerPort is not equal to the given one.
   */
  public S hasContainerPort(IntOrString containerPort) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    IntOrString actualContainerPort = actual.getContainerPort();
    if (!Objects.areEqual(actualContainerPort, containerPort)) {
      failWithMessage(assertjErrorMessage, actual, containerPort, actualContainerPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's createExternalLoadBalancer is equal to the given one.
   * @param createExternalLoadBalancer the given createExternalLoadBalancer to compare the actual Service's createExternalLoadBalancer to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's createExternalLoadBalancer is not equal to the given one.
   */
  public S hasCreateExternalLoadBalancer(Boolean createExternalLoadBalancer) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected createExternalLoadBalancer of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualCreateExternalLoadBalancer = actual.getCreateExternalLoadBalancer();
    if (!Objects.areEqual(actualCreateExternalLoadBalancer, createExternalLoadBalancer)) {
      failWithMessage(assertjErrorMessage, actual, createExternalLoadBalancer, actualCreateExternalLoadBalancer);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual Service's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's id is equal to the given one.
   * @param id the given id to compare the actual Service's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's kind is equal to the given one.
   * @param kind the given kind to compare the actual Service's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's labels is equal to the given one.
   * @param labels the given labels to compare the actual Service's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual Service's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's port is equal to the given one.
   * @param port the given port to compare the actual Service's port to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's port is not equal to the given one.
   */
  public S hasPort(Integer port) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPort = actual.getPort();
    if (!Objects.areEqual(actualPort, port)) {
      failWithMessage(assertjErrorMessage, actual, port, actualPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's portalIP is equal to the given one.
   * @param portalIP the given portalIP to compare the actual Service's portalIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's portalIP is not equal to the given one.
   */
  public S hasPortalIP(String portalIP) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected portalIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPortalIP = actual.getPortalIP();
    if (!Objects.areEqual(actualPortalIP, portalIP)) {
      failWithMessage(assertjErrorMessage, actual, portalIP, actualPortalIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's protocol is equal to the given one.
   * @param protocol the given protocol to compare the actual Service's protocol to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's protocol is not equal to the given one.
   */
  public S hasProtocol(String protocol) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected protocol of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualProtocol = actual.getProtocol();
    if (!Objects.areEqual(actualProtocol, protocol)) {
      failWithMessage(assertjErrorMessage, actual, protocol, actualProtocol);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's proxyPort is equal to the given one.
   * @param proxyPort the given proxyPort to compare the actual Service's proxyPort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's proxyPort is not equal to the given one.
   */
  public S hasProxyPort(Integer proxyPort) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected proxyPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualProxyPort = actual.getProxyPort();
    if (!Objects.areEqual(actualProxyPort, proxyPort)) {
      failWithMessage(assertjErrorMessage, actual, proxyPort, actualProxyPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's publicIPs contains the given String elements.
   * @param publicIPs the given elements that should be contained in actual Service's publicIPs.
   * @return this assertion object.
   * @throws AssertionError if the actual Service's publicIPs does not contain all given String elements.
   */
  public S hasPublicIPs(String... publicIPs) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (publicIPs == null) throw new AssertionError("Expecting publicIPs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPublicIPs(), publicIPs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service has no publicIPs.
   * @return this assertion object.
   * @throws AssertionError if the actual Service's publicIPs is not empty.
   */
  public S hasNoPublicIPs() {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have publicIPs but had :\n  <%s>";
    
    // check
    if (actual.getPublicIPs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPublicIPs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Service's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual Service's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(Integer resourceVersion) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's selector is equal to the given one.
   * @param selector the given selector to compare the actual Service's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's selector is not equal to the given one.
   */
  public S hasSelector(java.util.Map selector) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual Service's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's sessionAffinity is equal to the given one.
   * @param sessionAffinity the given sessionAffinity to compare the actual Service's sessionAffinity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's sessionAffinity is not equal to the given one.
   */
  public S hasSessionAffinity(String sessionAffinity) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected sessionAffinity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSessionAffinity = actual.getSessionAffinity();
    if (!Objects.areEqual(actualSessionAffinity, sessionAffinity)) {
      failWithMessage(assertjErrorMessage, actual, sessionAffinity, actualSessionAffinity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Service's uid is equal to the given one.
   * @param uid the given uid to compare the actual Service's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Service's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual Service we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
