/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodAssert;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListAssert;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerAssert;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerListAssert;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAssert;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceListAssert;
import io.fabric8.kubernetes.assertions.Assertions;
import io.fabric8.kubernetes.assertions.PodsAssert;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ListAssert;

public class KubernetesAssert
extends AbstractAssert<KubernetesAssert, KubernetesClient> {
    private final KubernetesClient client;

    public KubernetesAssert(KubernetesClient client) {
        super((Object)client, KubernetesAssert.class);
        this.client = client;
    }

    public PodListAssert podList() {
        PodList pods = this.client.getPods();
        return (PodListAssert)Assertions.assertThat(pods).isNotNull();
    }

    public PodsAssert pods() {
        List<Pod> pods = this.getPods();
        return Assertions.assertThat(pods);
    }

    protected List<Pod> getPods() {
        PodList podList = this.client.getPods();
        Assertions.assertThat(podList).isNotNull();
        List<Pod> pods = podList.getItems();
        Assertions.assertThat(pods).isNotNull();
        return pods;
    }

    public ReplicationControllerListAssert replicationControllerList() {
        ReplicationControllerList replicationControllers = this.client.getReplicationControllers();
        return (ReplicationControllerListAssert)Assertions.assertThat(replicationControllers).isNotNull();
    }

    public ListAssert<ReplicationController> replicationControllers() {
        ReplicationControllerList replicationControllerList = this.client.getReplicationControllers();
        Assertions.assertThat(replicationControllerList).isNotNull();
        List<ReplicationController> replicationControllers = replicationControllerList.getItems();
        return (ListAssert)org.assertj.core.api.Assertions.assertThat(replicationControllers);
    }

    public ServiceListAssert serviceList() {
        ServiceList serviceList = this.client.getServices();
        return (ServiceListAssert)Assertions.assertThat(serviceList).isNotNull();
    }

    public ListAssert<Service> services() {
        ServiceList serviceList = this.client.getServices();
        Assertions.assertThat(serviceList).isNotNull();
        List<Service> services = serviceList.getItems();
        return (ListAssert)org.assertj.core.api.Assertions.assertThat(services);
    }

    public PodsAssert podsForReplicationController(String replicationControllerId) {
        ReplicationController replicationController = this.getReplicationController(replicationControllerId);
        return this.podsForReplicationController(replicationController);
    }

    public PodsAssert podsForReplicationController(ReplicationController replicationController) {
        List<Pod> allPods = this.getPods();
        List pods = KubernetesHelper.getPodsForReplicationController((ReplicationController)replicationController, allPods);
        return Assertions.assertThat(pods);
    }

    public PodsAssert podsForService(String serviceId) {
        Service service = this.getService(serviceId);
        return this.podsForService(service);
    }

    public PodsAssert podsForService(Service service) {
        List<Pod> allPods = this.getPods();
        List pods = KubernetesHelper.getPodsForService((Service)service, allPods);
        return Assertions.assertThat(pods);
    }

    public ReplicationControllerAssert replicationController(String replicationControllerId) {
        return Assertions.assertThat(this.getReplicationController(replicationControllerId));
    }

    protected ReplicationController getReplicationController(String replicationControllerId) {
        org.assertj.core.api.Assertions.assertThat((String)replicationControllerId).isNotNull();
        ReplicationController replicationController = null;
        try {
            replicationController = this.client.getReplicationController(replicationControllerId);
        }
        catch (NotFoundException e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find replicationController for '" + replicationControllerId + "'"));
        }
        Assertions.assertThat(replicationController).isNotNull();
        return replicationController;
    }

    public ServiceAssert service(String serviceId) {
        return Assertions.assertThat(this.getService(serviceId));
    }

    protected Service getService(String serviceId) {
        org.assertj.core.api.Assertions.assertThat((String)serviceId).isNotNull();
        Service service = null;
        try {
            service = this.client.getService(serviceId);
        }
        catch (NotFoundException e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find service for '" + serviceId + "'"));
        }
        Assertions.assertThat(service).isNotNull();
        return service;
    }

    public PodAssert pod(String podId) {
        return Assertions.assertThat(this.getPod(podId));
    }

    protected Pod getPod(String podId) {
        org.assertj.core.api.Assertions.assertThat((String)podId).isNotNull();
        Pod pod = null;
        try {
            pod = this.client.getPod(podId);
        }
        catch (NotFoundException e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find pod for '" + podId + "'"));
        }
        Assertions.assertThat(pod).isNotNull();
        return pod;
    }
}

