package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodTemplateSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodTemplateSpecAssert<S extends AbstractPodTemplateSpecAssert<S, A>, A extends PodTemplateSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodTemplateSpecAssert}</code> to make assertions on actual PodTemplateSpec.
   * @param actual the PodTemplateSpec we want to make assertions on.
   */
  protected AbstractPodTemplateSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodTemplateSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodTemplateSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpec's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual PodTemplateSpec's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpec's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual PodTemplateSpec's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpec's labels is equal to the given one.
   * @param labels the given labels to compare the actual PodTemplateSpec's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpec's name is equal to the given one.
   * @param name the given name to compare the actual PodTemplateSpec's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpec's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual PodTemplateSpec's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpec's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual PodTemplateSpec's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(String resourceVersion) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpec's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual PodTemplateSpec's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpec's spec is equal to the given one.
   * @param spec the given spec to compare the actual PodTemplateSpec's spec to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's spec is not equal to the given one.
   */
  public S hasSpec(PodSpec spec) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected spec of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodSpec actualSpec = actual.getSpec();
    if (!Objects.areEqual(actualSpec, spec)) {
      failWithMessage(assertjErrorMessage, actual, spec, actualSpec);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpec's uid is equal to the given one.
   * @param uid the given uid to compare the actual PodTemplateSpec's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpec's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
