package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStatusAssert<S extends AbstractContainerStatusAssert<S, A>, A extends ContainerStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStatusAssert}</code> to make assertions on actual ContainerStatus.
   * @param actual the ContainerStatus we want to make assertions on.
   */
  protected AbstractContainerStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's containerID is equal to the given one.
   * @param containerID the given containerID to compare the actual ContainerStatus's containerID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's containerID is not equal to the given one.
   */
  public S hasContainerID(String containerID) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContainerID = actual.getContainerID();
    if (!Objects.areEqual(actualContainerID, containerID)) {
      failWithMessage(assertjErrorMessage, actual, containerID, actualContainerID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's image is equal to the given one.
   * @param image the given image to compare the actual ContainerStatus's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's podIP is equal to the given one.
   * @param podIP the given podIP to compare the actual ContainerStatus's podIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's podIP is not equal to the given one.
   */
  public S hasPodIP(String podIP) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected podIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPodIP = actual.getPodIP();
    if (!Objects.areEqual(actualPodIP, podIP)) {
      failWithMessage(assertjErrorMessage, actual, podIP, actualPodIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's restartCount is equal to the given one.
   * @param restartCount the given restartCount to compare the actual ContainerStatus's restartCount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's restartCount is not equal to the given one.
   */
  public S hasRestartCount(Integer restartCount) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected restartCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRestartCount = actual.getRestartCount();
    if (!Objects.areEqual(actualRestartCount, restartCount)) {
      failWithMessage(assertjErrorMessage, actual, restartCount, actualRestartCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatus's state is equal to the given one.
   * @param state the given state to compare the actual ContainerStatus's state to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatus's state is not equal to the given one.
   */
  public S hasState(ContainerState state) {
    // check that actual ContainerStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected state of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerState actualState = actual.getState();
    if (!Objects.areEqual(actualState, state)) {
      failWithMessage(assertjErrorMessage, actual, state, actualState);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
