package io.fabric8.kubernetes.assertions.internal;

/**
 * Entry point for assertions of different data types. Each method in this class is a static factory for the
 * type-specific assertion objects.
 */
public class Assertions {

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CauseAssert assertThat(io.fabric8.kubernetes.api.model.Cause actual) {
    return new io.fabric8.kubernetes.api.model.CauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.Container actual) {
    return new io.fabric8.kubernetes.api.model.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerManifestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerManifestAssert assertThat(io.fabric8.kubernetes.api.model.ContainerManifest actual) {
    return new io.fabric8.kubernetes.api.model.ContainerManifestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.ContainerState actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DetailsAssert assertThat(io.fabric8.kubernetes.api.model.Details actual) {
    return new io.fabric8.kubernetes.api.model.DetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDir actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsAssert assertThat(io.fabric8.kubernetes.api.model.Endpoints actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ErrorSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ErrorSchemaAssert assertThat(io.fabric8.kubernetes.api.model.ErrorSchema actual) {
    return new io.fabric8.kubernetes.api.model.ErrorSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDisk actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoAssert assertThat(io.fabric8.kubernetes.api.model.GitRepo actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.Handler actual) {
    return new io.fabric8.kubernetes.api.model.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostDirAssert assertThat(io.fabric8.kubernetes.api.model.HostDir actual) {
    return new io.fabric8.kubernetes.api.model.HostDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.IntOrString actual) {
    return new io.fabric8.kubernetes.api.model.IntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LivenessProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LivenessProbeAssert assertThat(io.fabric8.kubernetes.api.model.LivenessProbe actual) {
    return new io.fabric8.kubernetes.api.model.LivenessProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionAssert assertThat(io.fabric8.kubernetes.api.model.Minion actual) {
    return new io.fabric8.kubernetes.api.model.MinionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionListAssert assertThat(io.fabric8.kubernetes.api.model.MinionList actual) {
    return new io.fabric8.kubernetes.api.model.MinionListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeResourcesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeResourcesAssert assertThat(io.fabric8.kubernetes.api.model.NodeResources actual) {
    return new io.fabric8.kubernetes.api.model.NodeResourcesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAssert assertThat(io.fabric8.kubernetes.api.model.Pod actual) {
    return new io.fabric8.kubernetes.api.model.PodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListAssert assertThat(io.fabric8.kubernetes.api.model.PodList actual) {
    return new io.fabric8.kubernetes.api.model.PodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStateAssert assertThat(io.fabric8.kubernetes.api.model.PodState actual) {
    return new io.fabric8.kubernetes.api.model.PodStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplate actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PortAssert assertThat(io.fabric8.kubernetes.api.model.Port actual) {
    return new io.fabric8.kubernetes.api.model.PortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RawExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RawExtensionAssert assertThat(io.fabric8.kubernetes.api.model.RawExtension actual) {
    return new io.fabric8.kubernetes.api.model.RawExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStateAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerState actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicy actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyAlwaysAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyAlwaysAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyAlways actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyAlwaysAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyNeverAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyNeverAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyNever actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyNeverAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyOnFailureAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyOnFailureAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyOnFailure actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyOnFailureAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAssert assertThat(io.fabric8.kubernetes.api.model.Service actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.Volume actual) {
    return new io.fabric8.kubernetes.api.model.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.VolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.VolumeSourceAssert(actual);
  }

  /**
   * Creates a new <code>{@link Assertions}</code>.
   */
  protected Assertions() {
    // empty
  }
}
