package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Minion} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractMinionAssert<S extends AbstractMinionAssert<S, A>, A extends Minion> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMinionAssert}</code> to make assertions on actual Minion.
   * @param actual the Minion we want to make assertions on.
   */
  protected AbstractMinionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Minion's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Minion's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual Minion's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual Minion's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual Minion's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's hostIP is equal to the given one.
   * @param hostIP the given hostIP to compare the actual Minion's hostIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's hostIP is not equal to the given one.
   */
  public S hasHostIP(String hostIP) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected hostIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHostIP = actual.getHostIP();
    if (!Objects.areEqual(actualHostIP, hostIP)) {
      failWithMessage(assertjErrorMessage, actual, hostIP, actualHostIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's id is equal to the given one.
   * @param id the given id to compare the actual Minion's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's kind is equal to the given one.
   * @param kind the given kind to compare the actual Minion's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's labels is equal to the given one.
   * @param labels the given labels to compare the actual Minion's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual Minion's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual Minion's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(Integer resourceVersion) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's resources is equal to the given one.
   * @param resources the given resources to compare the actual Minion's resources to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's resources is not equal to the given one.
   */
  public S hasResources(NodeResources resources) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resources of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeResources actualResources = actual.getResources();
    if (!Objects.areEqual(actualResources, resources)) {
      failWithMessage(assertjErrorMessage, actual, resources, actualResources);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual Minion's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Minion's uid is equal to the given one.
   * @param uid the given uid to compare the actual Minion's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Minion's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual Minion we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
