package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link KubeSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubeSchemaAssert<S extends AbstractKubeSchemaAssert<S, A>, A extends KubeSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubeSchemaAssert}</code> to make assertions on actual KubeSchema.
   * @param actual the KubeSchema we want to make assertions on.
   */
  protected AbstractKubeSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubeSchema's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual KubeSchema's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's buildConfigList is equal to the given one.
   * @param buildConfigList the given buildConfigList to compare the actual KubeSchema's buildConfigList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's buildConfigList is not equal to the given one.
   */
  public S hasBuildConfigList(io.fabric8.openshift.api.model.BuildConfigList buildConfigList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected buildConfigList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildConfigList actualBuildConfigList = actual.getBuildConfigList();
    if (!Objects.areEqual(actualBuildConfigList, buildConfigList)) {
      failWithMessage(assertjErrorMessage, actual, buildConfigList, actualBuildConfigList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's buildList is equal to the given one.
   * @param buildList the given buildList to compare the actual KubeSchema's buildList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's buildList is not equal to the given one.
   */
  public S hasBuildList(io.fabric8.openshift.api.model.BuildList buildList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected buildList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildList actualBuildList = actual.getBuildList();
    if (!Objects.areEqual(actualBuildList, buildList)) {
      failWithMessage(assertjErrorMessage, actual, buildList, actualBuildList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's config is equal to the given one.
   * @param config the given config to compare the actual KubeSchema's config to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's config is not equal to the given one.
   */
  public S hasConfig(io.fabric8.openshift.api.model.Config config) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected config of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Config actualConfig = actual.getConfig();
    if (!Objects.areEqual(actualConfig, config)) {
      failWithMessage(assertjErrorMessage, actual, config, actualConfig);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's containerStatus is equal to the given one.
   * @param containerStatus the given containerStatus to compare the actual KubeSchema's containerStatus to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's containerStatus is not equal to the given one.
   */
  public S hasContainerStatus(ContainerStatus containerStatus) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerStatus of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerStatus actualContainerStatus = actual.getContainerStatus();
    if (!Objects.areEqual(actualContainerStatus, containerStatus)) {
      failWithMessage(assertjErrorMessage, actual, containerStatus, actualContainerStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's deploymentConfigList is equal to the given one.
   * @param deploymentConfigList the given deploymentConfigList to compare the actual KubeSchema's deploymentConfigList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's deploymentConfigList is not equal to the given one.
   */
  public S hasDeploymentConfigList(io.fabric8.openshift.api.model.DeploymentConfigList deploymentConfigList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected deploymentConfigList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.DeploymentConfigList actualDeploymentConfigList = actual.getDeploymentConfigList();
    if (!Objects.areEqual(actualDeploymentConfigList, deploymentConfigList)) {
      failWithMessage(assertjErrorMessage, actual, deploymentConfigList, actualDeploymentConfigList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's deploymentList is equal to the given one.
   * @param deploymentList the given deploymentList to compare the actual KubeSchema's deploymentList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's deploymentList is not equal to the given one.
   */
  public S hasDeploymentList(io.fabric8.openshift.api.model.DeploymentList deploymentList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected deploymentList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.DeploymentList actualDeploymentList = actual.getDeploymentList();
    if (!Objects.areEqual(actualDeploymentList, deploymentList)) {
      failWithMessage(assertjErrorMessage, actual, deploymentList, actualDeploymentList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's endpoints is equal to the given one.
   * @param endpoints the given endpoints to compare the actual KubeSchema's endpoints to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's endpoints is not equal to the given one.
   */
  public S hasEndpoints(Endpoints endpoints) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected endpoints of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Endpoints actualEndpoints = actual.getEndpoints();
    if (!Objects.areEqual(actualEndpoints, endpoints)) {
      failWithMessage(assertjErrorMessage, actual, endpoints, actualEndpoints);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's endpointsList is equal to the given one.
   * @param endpointsList the given endpointsList to compare the actual KubeSchema's endpointsList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's endpointsList is not equal to the given one.
   */
  public S hasEndpointsList(EndpointsList endpointsList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected endpointsList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EndpointsList actualEndpointsList = actual.getEndpointsList();
    if (!Objects.areEqual(actualEndpointsList, endpointsList)) {
      failWithMessage(assertjErrorMessage, actual, endpointsList, actualEndpointsList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's imageList is equal to the given one.
   * @param imageList the given imageList to compare the actual KubeSchema's imageList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's imageList is not equal to the given one.
   */
  public S hasImageList(io.fabric8.openshift.api.model.ImageList imageList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ImageList actualImageList = actual.getImageList();
    if (!Objects.areEqual(actualImageList, imageList)) {
      failWithMessage(assertjErrorMessage, actual, imageList, actualImageList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's imageRepositoryList is equal to the given one.
   * @param imageRepositoryList the given imageRepositoryList to compare the actual KubeSchema's imageRepositoryList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's imageRepositoryList is not equal to the given one.
   */
  public S hasImageRepositoryList(io.fabric8.openshift.api.model.ImageRepositoryList imageRepositoryList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageRepositoryList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ImageRepositoryList actualImageRepositoryList = actual.getImageRepositoryList();
    if (!Objects.areEqual(actualImageRepositoryList, imageRepositoryList)) {
      failWithMessage(assertjErrorMessage, actual, imageRepositoryList, actualImageRepositoryList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's minion is equal to the given one.
   * @param minion the given minion to compare the actual KubeSchema's minion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's minion is not equal to the given one.
   */
  public S hasMinion(Minion minion) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected minion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Minion actualMinion = actual.getMinion();
    if (!Objects.areEqual(actualMinion, minion)) {
      failWithMessage(assertjErrorMessage, actual, minion, actualMinion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's minionList is equal to the given one.
   * @param minionList the given minionList to compare the actual KubeSchema's minionList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's minionList is not equal to the given one.
   */
  public S hasMinionList(MinionList minionList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected minionList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    MinionList actualMinionList = actual.getMinionList();
    if (!Objects.areEqual(actualMinionList, minionList)) {
      failWithMessage(assertjErrorMessage, actual, minionList, actualMinionList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's podList is equal to the given one.
   * @param podList the given podList to compare the actual KubeSchema's podList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's podList is not equal to the given one.
   */
  public S hasPodList(PodList podList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected podList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodList actualPodList = actual.getPodList();
    if (!Objects.areEqual(actualPodList, podList)) {
      failWithMessage(assertjErrorMessage, actual, podList, actualPodList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's replicationControllerList is equal to the given one.
   * @param replicationControllerList the given replicationControllerList to compare the actual KubeSchema's replicationControllerList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's replicationControllerList is not equal to the given one.
   */
  public S hasReplicationControllerList(ReplicationControllerList replicationControllerList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected replicationControllerList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ReplicationControllerList actualReplicationControllerList = actual.getReplicationControllerList();
    if (!Objects.areEqual(actualReplicationControllerList, replicationControllerList)) {
      failWithMessage(assertjErrorMessage, actual, replicationControllerList, actualReplicationControllerList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's routeList is equal to the given one.
   * @param routeList the given routeList to compare the actual KubeSchema's routeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's routeList is not equal to the given one.
   */
  public S hasRouteList(io.fabric8.openshift.api.model.RouteList routeList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected routeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RouteList actualRouteList = actual.getRouteList();
    if (!Objects.areEqual(actualRouteList, routeList)) {
      failWithMessage(assertjErrorMessage, actual, routeList, actualRouteList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's serviceList is equal to the given one.
   * @param serviceList the given serviceList to compare the actual KubeSchema's serviceList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's serviceList is not equal to the given one.
   */
  public S hasServiceList(ServiceList serviceList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected serviceList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceList actualServiceList = actual.getServiceList();
    if (!Objects.areEqual(actualServiceList, serviceList)) {
      failWithMessage(assertjErrorMessage, actual, serviceList, actualServiceList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's template is equal to the given one.
   * @param template the given template to compare the actual KubeSchema's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.openshift.api.model.Template template) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Template actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
