package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ErrorSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractErrorSchemaAssert<S extends AbstractErrorSchemaAssert<S, A>, A extends ErrorSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractErrorSchemaAssert}</code> to make assertions on actual ErrorSchema.
   * @param actual the ErrorSchema we want to make assertions on.
   */
  protected AbstractErrorSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ErrorSchema's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ErrorSchema's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorSchema's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ErrorSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorSchema's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ErrorSchema's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorSchema's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ErrorSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorSchema's code is close to the given value by less than the given offset.
   * <p>
   * If difference is equal to the offset value, assertion is considered successful.
   * @param code the value to compare the actual ErrorSchema's code to.
   * @param offset the given offset.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorSchema's code is not close enough to the given value.
   */
  public S hasCode(Double code, Double offset) {
    // check that actual ErrorSchema we want to make assertions on is not null.
    isNotNull();

    Double actualCode = actual.getCode();
    
    // overrides the default error message with a more explicit one
    String assertjErrorMessage = String.format("\nExpected code:\n  <%s>\nto be close to:\n  <%s>\nby less than <%s> but difference was <%s>",
                                               actualCode, code, offset, Math.abs(code - actualCode));
    
    // check
    Assertions.assertThat(actualCode).overridingErrorMessage(assertjErrorMessage).isCloseTo(code, Assertions.within(offset));

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorSchema's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual ErrorSchema's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorSchema's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(Object creationTimestamp) {
    // check that actual ErrorSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Object actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorSchema's details is equal to the given one.
   * @param details the given details to compare the actual ErrorSchema's details to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorSchema's details is not equal to the given one.
   */
  public S hasDetails(Details details) {
    // check that actual ErrorSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected details of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Details actualDetails = actual.getDetails();
    if (!Objects.areEqual(actualDetails, details)) {
      failWithMessage(assertjErrorMessage, actual, details, actualDetails);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorSchema's kind is equal to the given one.
   * @param kind the given kind to compare the actual ErrorSchema's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorSchema's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ErrorSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorSchema's message is equal to the given one.
   * @param message the given message to compare the actual ErrorSchema's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorSchema's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual ErrorSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorSchema's reason is equal to the given one.
   * @param reason the given reason to compare the actual ErrorSchema's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorSchema's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual ErrorSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorSchema's status is equal to the given one.
   * @param status the given status to compare the actual ErrorSchema's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorSchema's status is not equal to the given one.
   */
  public S hasStatus(String status) {
    // check that actual ErrorSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
