package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerManifest} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerManifestAssert<S extends AbstractContainerManifestAssert<S, A>, A extends ContainerManifest> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerManifestAssert}</code> to make assertions on actual ContainerManifest.
   * @param actual the ContainerManifest we want to make assertions on.
   */
  protected AbstractContainerManifestAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerManifest's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerManifest's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerManifest's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerManifest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerManifest's containers contains the given Container elements.
   * @param containers the given elements that should be contained in actual ContainerManifest's containers.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerManifest's containers does not contain all given Container elements.
   */
  public S hasContainers(Container... containers) {
    // check that actual ContainerManifest we want to make assertions on is not null.
    isNotNull();

    // check that given Container varargs is not null.
    if (containers == null) throw new AssertionError("Expecting containers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getContainers(), containers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerManifest has no containers.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerManifest's containers is not empty.
   */
  public S hasNoContainers() {
    // check that actual ContainerManifest we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have containers but had :\n  <%s>";
    
    // check
    if (actual.getContainers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getContainers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContainerManifest's id is equal to the given one.
   * @param id the given id to compare the actual ContainerManifest's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerManifest's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual ContainerManifest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerManifest's restartPolicy is equal to the given one.
   * @param restartPolicy the given restartPolicy to compare the actual ContainerManifest's restartPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerManifest's restartPolicy is not equal to the given one.
   */
  public S hasRestartPolicy(RestartPolicy restartPolicy) {
    // check that actual ContainerManifest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected restartPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RestartPolicy actualRestartPolicy = actual.getRestartPolicy();
    if (!Objects.areEqual(actualRestartPolicy, restartPolicy)) {
      failWithMessage(assertjErrorMessage, actual, restartPolicy, actualRestartPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerManifest's uuid is equal to the given one.
   * @param uuid the given uuid to compare the actual ContainerManifest's uuid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerManifest's uuid is not equal to the given one.
   */
  public S hasUuid(String uuid) {
    // check that actual ContainerManifest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uuid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUuid = actual.getUuid();
    if (!Objects.areEqual(actualUuid, uuid)) {
      failWithMessage(assertjErrorMessage, actual, uuid, actualUuid);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerManifest's version is equal to the given one.
   * @param version the given version to compare the actual ContainerManifest's version to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerManifest's version is not equal to the given one.
   */
  public S hasVersion(String version) {
    // check that actual ContainerManifest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualVersion = actual.getVersion();
    if (!Objects.areEqual(actualVersion, version)) {
      failWithMessage(assertjErrorMessage, actual, version, actualVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerManifest's volumes contains the given Volume elements.
   * @param volumes the given elements that should be contained in actual ContainerManifest's volumes.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerManifest's volumes does not contain all given Volume elements.
   */
  public S hasVolumes(Volume... volumes) {
    // check that actual ContainerManifest we want to make assertions on is not null.
    isNotNull();

    // check that given Volume varargs is not null.
    if (volumes == null) throw new AssertionError("Expecting volumes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVolumes(), volumes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerManifest has no volumes.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerManifest's volumes is not empty.
   */
  public S hasNoVolumes() {
    // check that actual ContainerManifest we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have volumes but had :\n  <%s>";
    
    // check
    if (actual.getVolumes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVolumes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
