/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatus;
import io.fabric8.kubernetes.api.model.PodSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchema;
import io.fabric8.kubernetes.api.model.ServiceSchema;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Condition;

public class Conditions {
    public static Condition<PodSchema> status(final PodStatus status) {
        return new Condition<PodSchema>(){

            public String toString() {
                return "podStatus(" + status + ")";
            }

            public boolean matches(PodSchema pod) {
                return Objects.equals(status, KubernetesHelper.getPodStatus((PodSchema)pod));
            }
        };
    }

    public static Condition<PodSchema> runningStatus() {
        return Conditions.status(PodStatus.OK);
    }

    public static Condition<PodSchema> waitingStatus() {
        return Conditions.status(PodStatus.WAIT);
    }

    public static Condition<PodSchema> errorStatus() {
        return Conditions.status(PodStatus.ERROR);
    }

    public static Condition<PodSchema> podLabel(final String key, final String value) {
        return new Condition<PodSchema>(){

            public String toString() {
                return "podLabel(" + key + " = " + value + ")";
            }

            public boolean matches(PodSchema pod) {
                return Conditions.matchesLabel(pod.getLabels(), key, value);
            }
        };
    }

    public static Condition<ReplicationControllerSchema> replicationControllerLabel(final String key, final String value) {
        return new Condition<ReplicationControllerSchema>(){

            public String toString() {
                return "replicationControllerLabel(" + key + " = " + value + ")";
            }

            public boolean matches(ReplicationControllerSchema replicationControllerSchema) {
                return Conditions.matchesLabel(replicationControllerSchema.getLabels(), key, value);
            }
        };
    }

    public static Condition<ServiceSchema> serviceLabel(final String key, final String value) {
        return new Condition<ServiceSchema>(){

            public String toString() {
                return "serviceLabel(" + key + " = " + value + ")";
            }

            public boolean matches(ServiceSchema service) {
                return Conditions.matchesLabel(service.getLabels(), key, value);
            }
        };
    }

    public static boolean matchesLabel(Map<String, String> labels, String key, String value) {
        if (labels != null) {
            String actual = labels.get(key);
            return Objects.equals(value, actual);
        }
        return false;
    }
}

