package io.fabric8.kubernetes.assertions.internal;

/**
 * Entry point for assertions of different data types. Each method in this class is a static factory for the
 * type-specific assertion objects.
 */
public class Assertions {

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CauseAssert assertThat(io.fabric8.kubernetes.api.model.Cause actual) {
    return new io.fabric8.kubernetes.api.model.CauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigAssert assertThat(io.fabric8.kubernetes.api.model.Config actual) {
    return new io.fabric8.kubernetes.api.model.ConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ControllerCurrentStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ControllerCurrentStateAssert assertThat(io.fabric8.kubernetes.api.model.ControllerCurrentState actual) {
    return new io.fabric8.kubernetes.api.model.ControllerCurrentStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ControllerDesiredStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ControllerDesiredStateAssert assertThat(io.fabric8.kubernetes.api.model.ControllerDesiredState actual) {
    return new io.fabric8.kubernetes.api.model.ControllerDesiredStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CurrentStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CurrentStateAssert assertThat(io.fabric8.kubernetes.api.model.CurrentState actual) {
    return new io.fabric8.kubernetes.api.model.CurrentStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DesiredStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DesiredStateAssert assertThat(io.fabric8.kubernetes.api.model.DesiredState actual) {
    return new io.fabric8.kubernetes.api.model.DesiredStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DetailInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DetailInfoAssert assertThat(io.fabric8.kubernetes.api.model.DetailInfo actual) {
    return new io.fabric8.kubernetes.api.model.DetailInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DetailsAssert assertThat(io.fabric8.kubernetes.api.model.Details actual) {
    return new io.fabric8.kubernetes.api.model.DetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvAssert assertThat(io.fabric8.kubernetes.api.model.Env actual) {
    return new io.fabric8.kubernetes.api.model.EnvAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ErrorSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ErrorSchemaAssert assertThat(io.fabric8.kubernetes.api.model.ErrorSchema actual) {
    return new io.fabric8.kubernetes.api.model.ErrorSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.InfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.InfoAssert assertThat(io.fabric8.kubernetes.api.model.Info actual) {
    return new io.fabric8.kubernetes.api.model.InfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ItemAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ItemAssert assertThat(io.fabric8.kubernetes.api.model.Item actual) {
    return new io.fabric8.kubernetes.api.model.ItemAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.Item_Assert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.Item_Assert assertThat(io.fabric8.kubernetes.api.model.Item_ actual) {
    return new io.fabric8.kubernetes.api.model.Item_Assert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ManifestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ManifestAssert assertThat(io.fabric8.kubernetes.api.model.Manifest actual) {
    return new io.fabric8.kubernetes.api.model.ManifestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ManifestContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ManifestContainerAssert assertThat(io.fabric8.kubernetes.api.model.ManifestContainer actual) {
    return new io.fabric8.kubernetes.api.model.ManifestContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ParameterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ParameterAssert assertThat(io.fabric8.kubernetes.api.model.Parameter actual) {
    return new io.fabric8.kubernetes.api.model.ParameterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodContainerManifestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodContainerManifestAssert assertThat(io.fabric8.kubernetes.api.model.PodContainerManifest actual) {
    return new io.fabric8.kubernetes.api.model.PodContainerManifestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodCurrentContainerInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodCurrentContainerInfoAssert assertThat(io.fabric8.kubernetes.api.model.PodCurrentContainerInfo actual) {
    return new io.fabric8.kubernetes.api.model.PodCurrentContainerInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListSchemaAssert assertThat(io.fabric8.kubernetes.api.model.PodListSchema actual) {
    return new io.fabric8.kubernetes.api.model.PodListSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSchemaAssert assertThat(io.fabric8.kubernetes.api.model.PodSchema actual) {
    return new io.fabric8.kubernetes.api.model.PodSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplate actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateDesiredStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateDesiredStateAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateDesiredState actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateDesiredStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplate_Assert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplate_Assert assertThat(io.fabric8.kubernetes.api.model.PodTemplate_ actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplate_Assert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PortAssert assertThat(io.fabric8.kubernetes.api.model.Port actual) {
    return new io.fabric8.kubernetes.api.model.PortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PullPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PullPolicyAssert assertThat(io.fabric8.kubernetes.api.model.PullPolicy actual) {
    return new io.fabric8.kubernetes.api.model.PullPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListSchemaAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerListSchema actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSchemaAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSchema actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RunningAssert assertThat(io.fabric8.kubernetes.api.model.Running actual) {
    return new io.fabric8.kubernetes.api.model.RunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListSchemaAssert assertThat(io.fabric8.kubernetes.api.model.ServiceListSchema actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSchemaAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSchema actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StateAssert assertThat(io.fabric8.kubernetes.api.model.State actual) {
    return new io.fabric8.kubernetes.api.model.StateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TemplateAssert assertThat(io.fabric8.kubernetes.api.model.Template actual) {
    return new io.fabric8.kubernetes.api.model.TemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.Volume actual) {
    return new io.fabric8.kubernetes.api.model.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountAssert(actual);
  }

  /**
   * Creates a new <code>{@link Assertions}</code>.
   */
  protected Assertions() {
    // empty
  }
}
