package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link State} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStateAssert<S extends AbstractStateAssert<S, A>, A extends State> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStateAssert}</code> to make assertions on actual State.
   * @param actual the State we want to make assertions on.
   */
  protected AbstractStateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual State's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual State's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual State's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual State we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual State's running is equal to the given one.
   * @param running the given running to compare the actual State's running to.
   * @return this assertion object.
   * @throws AssertionError - if the actual State's running is not equal to the given one.
   */
  public S hasRunning(Running running) {
    // check that actual State we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected running of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Running actualRunning = actual.getRunning();
    if (!Objects.areEqual(actualRunning, running)) {
      failWithMessage(assertjErrorMessage, actual, running, actualRunning);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
