package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ServiceSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceSchemaAssert<S extends AbstractServiceSchemaAssert<S, A>, A extends ServiceSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceSchemaAssert}</code> to make assertions on actual ServiceSchema.
   * @param actual the ServiceSchema we want to make assertions on.
   */
  protected AbstractServiceSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ServiceSchema's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ServiceSchema's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual ServiceSchema's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's containerPort is equal to the given one.
   * @param containerPort the given containerPort to compare the actual ServiceSchema's containerPort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's containerPort is not equal to the given one.
   */
  public S hasContainerPort(io.fabric8.kubernetes.api.IntOrString containerPort) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.IntOrString actualContainerPort = actual.getContainerPort();
    if (!Objects.areEqual(actualContainerPort, containerPort)) {
      failWithMessage(assertjErrorMessage, actual, containerPort, actualContainerPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual ServiceSchema's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's id is equal to the given one.
   * @param id the given id to compare the actual ServiceSchema's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's kind is equal to the given one.
   * @param kind the given kind to compare the actual ServiceSchema's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's labels is equal to the given one.
   * @param labels the given labels to compare the actual ServiceSchema's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's name is equal to the given one.
   * @param name the given name to compare the actual ServiceSchema's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual ServiceSchema's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's port is equal to the given one.
   * @param port the given port to compare the actual ServiceSchema's port to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's port is not equal to the given one.
   */
  public S hasPort(Integer port) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPort = actual.getPort();
    if (!Objects.areEqual(actualPort, port)) {
      failWithMessage(assertjErrorMessage, actual, port, actualPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's portalIP is equal to the given one.
   * @param portalIP the given portalIP to compare the actual ServiceSchema's portalIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's portalIP is not equal to the given one.
   */
  public S hasPortalIP(String portalIP) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected portalIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPortalIP = actual.getPortalIP();
    if (!Objects.areEqual(actualPortalIP, portalIP)) {
      failWithMessage(assertjErrorMessage, actual, portalIP, actualPortalIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's selector is equal to the given one.
   * @param selector the given selector to compare the actual ServiceSchema's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's selector is not equal to the given one.
   */
  public S hasSelector(java.util.Map selector) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSchema's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual ServiceSchema's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSchema's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual ServiceSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
