package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ServiceListSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceListSchemaAssert<S extends AbstractServiceListSchemaAssert<S, A>, A extends ServiceListSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceListSchemaAssert}</code> to make assertions on actual ServiceListSchema.
   * @param actual the ServiceListSchema we want to make assertions on.
   */
  protected AbstractServiceListSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ServiceListSchema's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ServiceListSchema's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceListSchema's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ServiceListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceListSchema's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ServiceListSchema's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceListSchema's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ServiceListSchema.ApiVersion apiVersion) {
    // check that actual ServiceListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceListSchema.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceListSchema's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual ServiceListSchema's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceListSchema's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual ServiceListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceListSchema's items contains the given ServiceSchema elements.
   * @param items the given elements that should be contained in actual ServiceListSchema's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceListSchema's items does not contain all given ServiceSchema elements.
   */
  public S hasItems(ServiceSchema... items) {
    // check that actual ServiceListSchema we want to make assertions on is not null.
    isNotNull();

    // check that given ServiceSchema varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceListSchema has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceListSchema's items is not empty.
   */
  public S hasNoItems() {
    // check that actual ServiceListSchema we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ServiceListSchema's kind is equal to the given one.
   * @param kind the given kind to compare the actual ServiceListSchema's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceListSchema's kind is not equal to the given one.
   */
  public S hasKind(ServiceListSchema.Kind kind) {
    // check that actual ServiceListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceListSchema.Kind actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceListSchema's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual ServiceListSchema's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceListSchema's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(Integer resourceVersion) {
    // check that actual ServiceListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
