package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ReplicationControllerListSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractReplicationControllerListSchemaAssert<S extends AbstractReplicationControllerListSchemaAssert<S, A>, A extends ReplicationControllerListSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractReplicationControllerListSchemaAssert}</code> to make assertions on actual ReplicationControllerListSchema.
   * @param actual the ReplicationControllerListSchema we want to make assertions on.
   */
  protected AbstractReplicationControllerListSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ReplicationControllerListSchema's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ReplicationControllerListSchema's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerListSchema's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ReplicationControllerListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerListSchema's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ReplicationControllerListSchema's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerListSchema's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ReplicationControllerListSchema.ApiVersion apiVersion) {
    // check that actual ReplicationControllerListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ReplicationControllerListSchema.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerListSchema's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual ReplicationControllerListSchema's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerListSchema's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual ReplicationControllerListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerListSchema's items contains the given ReplicationControllerSchema elements.
   * @param items the given elements that should be contained in actual ReplicationControllerListSchema's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ReplicationControllerListSchema's items does not contain all given ReplicationControllerSchema elements.
   */
  public S hasItems(ReplicationControllerSchema... items) {
    // check that actual ReplicationControllerListSchema we want to make assertions on is not null.
    isNotNull();

    // check that given ReplicationControllerSchema varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerListSchema has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual ReplicationControllerListSchema's items is not empty.
   */
  public S hasNoItems() {
    // check that actual ReplicationControllerListSchema we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ReplicationControllerListSchema's kind is equal to the given one.
   * @param kind the given kind to compare the actual ReplicationControllerListSchema's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerListSchema's kind is not equal to the given one.
   */
  public S hasKind(ReplicationControllerListSchema.Kind kind) {
    // check that actual ReplicationControllerListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ReplicationControllerListSchema.Kind actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerListSchema's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual ReplicationControllerListSchema's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerListSchema's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(Integer resourceVersion) {
    // check that actual ReplicationControllerListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
