package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodTemplateDesiredState} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodTemplateDesiredStateAssert<S extends AbstractPodTemplateDesiredStateAssert<S, A>, A extends PodTemplateDesiredState> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodTemplateDesiredStateAssert}</code> to make assertions on actual PodTemplateDesiredState.
   * @param actual the PodTemplateDesiredState we want to make assertions on.
   */
  protected AbstractPodTemplateDesiredStateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodTemplateDesiredState's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodTemplateDesiredState's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateDesiredState's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodTemplateDesiredState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateDesiredState's manifest is equal to the given one.
   * @param manifest the given manifest to compare the actual PodTemplateDesiredState's manifest to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateDesiredState's manifest is not equal to the given one.
   */
  public S hasManifest(Manifest manifest) {
    // check that actual PodTemplateDesiredState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected manifest of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Manifest actualManifest = actual.getManifest();
    if (!Objects.areEqual(actualManifest, manifest)) {
      failWithMessage(assertjErrorMessage, actual, manifest, actualManifest);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
