package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodTemplate} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodTemplateAssert<S extends AbstractPodTemplateAssert<S, A>, A extends PodTemplate> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodTemplateAssert}</code> to make assertions on actual PodTemplate.
   * @param actual the PodTemplate we want to make assertions on.
   */
  protected AbstractPodTemplateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodTemplate's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodTemplate's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplate's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplate's desiredState is equal to the given one.
   * @param desiredState the given desiredState to compare the actual PodTemplate's desiredState to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplate's desiredState is not equal to the given one.
   */
  public S hasDesiredState(PodTemplateDesiredState desiredState) {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected desiredState of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodTemplateDesiredState actualDesiredState = actual.getDesiredState();
    if (!Objects.areEqual(actualDesiredState, desiredState)) {
      failWithMessage(assertjErrorMessage, actual, desiredState, actualDesiredState);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplate's labels is equal to the given one.
   * @param labels the given labels to compare the actual PodTemplate's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplate's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
