package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSchemaAssert<S extends AbstractPodSchemaAssert<S, A>, A extends PodSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSchemaAssert}</code> to make assertions on actual PodSchema.
   * @param actual the PodSchema we want to make assertions on.
   */
  protected AbstractPodSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodSchema's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodSchema's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSchema's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual PodSchema's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSchema's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual PodSchema's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSchema's currentState is equal to the given one.
   * @param currentState the given currentState to compare the actual PodSchema's currentState to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's currentState is not equal to the given one.
   */
  public S hasCurrentState(CurrentState currentState) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected currentState of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CurrentState actualCurrentState = actual.getCurrentState();
    if (!Objects.areEqual(actualCurrentState, currentState)) {
      failWithMessage(assertjErrorMessage, actual, currentState, actualCurrentState);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSchema's desiredState is equal to the given one.
   * @param desiredState the given desiredState to compare the actual PodSchema's desiredState to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's desiredState is not equal to the given one.
   */
  public S hasDesiredState(DesiredState desiredState) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected desiredState of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DesiredState actualDesiredState = actual.getDesiredState();
    if (!Objects.areEqual(actualDesiredState, desiredState)) {
      failWithMessage(assertjErrorMessage, actual, desiredState, actualDesiredState);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSchema's id is equal to the given one.
   * @param id the given id to compare the actual PodSchema's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSchema's kind is equal to the given one.
   * @param kind the given kind to compare the actual PodSchema's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSchema's labels is equal to the given one.
   * @param labels the given labels to compare the actual PodSchema's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSchema's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual PodSchema's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSchema's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual PodSchema's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSchema's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual PodSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
