package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodListSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodListSchemaAssert<S extends AbstractPodListSchemaAssert<S, A>, A extends PodListSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodListSchemaAssert}</code> to make assertions on actual PodListSchema.
   * @param actual the PodListSchema we want to make assertions on.
   */
  protected AbstractPodListSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodListSchema's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodListSchema's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodListSchema's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodListSchema's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual PodListSchema's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodListSchema's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual PodListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodListSchema's id is equal to the given one.
   * @param id the given id to compare the actual PodListSchema's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodListSchema's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual PodListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodListSchema's items contains the given PodSchema elements.
   * @param items the given elements that should be contained in actual PodListSchema's items.
   * @return this assertion object.
   * @throws AssertionError if the actual PodListSchema's items does not contain all given PodSchema elements.
   */
  public S hasItems(PodSchema... items) {
    // check that actual PodListSchema we want to make assertions on is not null.
    isNotNull();

    // check that given PodSchema varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodListSchema has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual PodListSchema's items is not empty.
   */
  public S hasNoItems() {
    // check that actual PodListSchema we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PodListSchema's kind is equal to the given one.
   * @param kind the given kind to compare the actual PodListSchema's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodListSchema's kind is not equal to the given one.
   */
  public S hasKind(PodListSchema.Kind kind) {
    // check that actual PodListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodListSchema.Kind actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodListSchema's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual PodListSchema's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodListSchema's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual PodListSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
