package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodCurrentContainerInfo} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodCurrentContainerInfoAssert<S extends AbstractPodCurrentContainerInfoAssert<S, A>, A extends PodCurrentContainerInfo> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodCurrentContainerInfoAssert}</code> to make assertions on actual PodCurrentContainerInfo.
   * @param actual the PodCurrentContainerInfo we want to make assertions on.
   */
  protected AbstractPodCurrentContainerInfoAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodCurrentContainerInfo's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodCurrentContainerInfo's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodCurrentContainerInfo's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodCurrentContainerInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodCurrentContainerInfo's detailInfo is equal to the given one.
   * @param detailInfo the given detailInfo to compare the actual PodCurrentContainerInfo's detailInfo to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodCurrentContainerInfo's detailInfo is not equal to the given one.
   */
  public S hasDetailInfo(DetailInfo detailInfo) {
    // check that actual PodCurrentContainerInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected detailInfo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DetailInfo actualDetailInfo = actual.getDetailInfo();
    if (!Objects.areEqual(actualDetailInfo, detailInfo)) {
      failWithMessage(assertjErrorMessage, actual, detailInfo, actualDetailInfo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodCurrentContainerInfo's restartCount is equal to the given one.
   * @param restartCount the given restartCount to compare the actual PodCurrentContainerInfo's restartCount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodCurrentContainerInfo's restartCount is not equal to the given one.
   */
  public S hasRestartCount(Integer restartCount) {
    // check that actual PodCurrentContainerInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected restartCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRestartCount = actual.getRestartCount();
    if (!Objects.areEqual(actualRestartCount, restartCount)) {
      failWithMessage(assertjErrorMessage, actual, restartCount, actualRestartCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodCurrentContainerInfo's state is equal to the given one.
   * @param state the given state to compare the actual PodCurrentContainerInfo's state to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodCurrentContainerInfo's state is not equal to the given one.
   */
  public S hasState(State state) {
    // check that actual PodCurrentContainerInfo we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected state of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    State actualState = actual.getState();
    if (!Objects.areEqual(actualState, state)) {
      failWithMessage(assertjErrorMessage, actual, state, actualState);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
