package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Parameter} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractParameterAssert<S extends AbstractParameterAssert<S, A>, A extends Parameter> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractParameterAssert}</code> to make assertions on actual Parameter.
   * @param actual the Parameter we want to make assertions on.
   */
  protected AbstractParameterAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Parameter's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Parameter's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Parameter's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Parameter's description is equal to the given one.
   * @param description the given description to compare the actual Parameter's description to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Parameter's description is not equal to the given one.
   */
  public S hasDescription(String description) {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected description of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDescription = actual.getDescription();
    if (!Objects.areEqual(actualDescription, description)) {
      failWithMessage(assertjErrorMessage, actual, description, actualDescription);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Parameter's from is equal to the given one.
   * @param from the given from to compare the actual Parameter's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Parameter's from is not equal to the given one.
   */
  public S hasFrom(String from) {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Parameter's generate is equal to the given one.
   * @param generate the given generate to compare the actual Parameter's generate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Parameter's generate is not equal to the given one.
   */
  public S hasGenerate(String generate) {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected generate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualGenerate = actual.getGenerate();
    if (!Objects.areEqual(actualGenerate, generate)) {
      failWithMessage(assertjErrorMessage, actual, generate, actualGenerate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Parameter's name is equal to the given one.
   * @param name the given name to compare the actual Parameter's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Parameter's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Parameter's value is equal to the given one.
   * @param value the given value to compare the actual Parameter's value to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Parameter's value is not equal to the given one.
   */
  public S hasValue(String value) {
    // check that actual Parameter we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualValue = actual.getValue();
    if (!Objects.areEqual(actualValue, value)) {
      failWithMessage(assertjErrorMessage, actual, value, actualValue);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
