package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ManifestContainer} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractManifestContainerAssert<S extends AbstractManifestContainerAssert<S, A>, A extends ManifestContainer> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractManifestContainerAssert}</code> to make assertions on actual ManifestContainer.
   * @param actual the ManifestContainer we want to make assertions on.
   */
  protected AbstractManifestContainerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ManifestContainer's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ManifestContainer's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ManifestContainer's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ManifestContainer's command contains the given String elements.
   * @param command the given elements that should be contained in actual ManifestContainer's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ManifestContainer's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) throw new AssertionError("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ManifestContainer has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual ManifestContainer's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ManifestContainer's env contains the given Env elements.
   * @param env the given elements that should be contained in actual ManifestContainer's env.
   * @return this assertion object.
   * @throws AssertionError if the actual ManifestContainer's env does not contain all given Env elements.
   */
  public S hasEnv(Env... env) {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // check that given Env varargs is not null.
    if (env == null) throw new AssertionError("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ManifestContainer has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual ManifestContainer's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ManifestContainer's image is equal to the given one.
   * @param image the given image to compare the actual ManifestContainer's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ManifestContainer's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ManifestContainer's imagePullPolicy is equal to the given one.
   * @param imagePullPolicy the given imagePullPolicy to compare the actual ManifestContainer's imagePullPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ManifestContainer's imagePullPolicy is not equal to the given one.
   */
  public S hasImagePullPolicy(PullPolicy imagePullPolicy) {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imagePullPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PullPolicy actualImagePullPolicy = actual.getImagePullPolicy();
    if (!Objects.areEqual(actualImagePullPolicy, imagePullPolicy)) {
      failWithMessage(assertjErrorMessage, actual, imagePullPolicy, actualImagePullPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ManifestContainer's name is equal to the given one.
   * @param name the given name to compare the actual ManifestContainer's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ManifestContainer's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ManifestContainer's ports contains the given Port elements.
   * @param ports the given elements that should be contained in actual ManifestContainer's ports.
   * @return this assertion object.
   * @throws AssertionError if the actual ManifestContainer's ports does not contain all given Port elements.
   */
  public S hasPorts(Port... ports) {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // check that given Port varargs is not null.
    if (ports == null) throw new AssertionError("Expecting ports parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPorts(), ports);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ManifestContainer has no ports.
   * @return this assertion object.
   * @throws AssertionError if the actual ManifestContainer's ports is not empty.
   */
  public S hasNoPorts() {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have ports but had :\n  <%s>";
    
    // check
    if (actual.getPorts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPorts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ManifestContainer's volumeMounts contains the given VolumeMount elements.
   * @param volumeMounts the given elements that should be contained in actual ManifestContainer's volumeMounts.
   * @return this assertion object.
   * @throws AssertionError if the actual ManifestContainer's volumeMounts does not contain all given VolumeMount elements.
   */
  public S hasVolumeMounts(VolumeMount... volumeMounts) {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // check that given VolumeMount varargs is not null.
    if (volumeMounts == null) throw new AssertionError("Expecting volumeMounts parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVolumeMounts(), volumeMounts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ManifestContainer has no volumeMounts.
   * @return this assertion object.
   * @throws AssertionError if the actual ManifestContainer's volumeMounts is not empty.
   */
  public S hasNoVolumeMounts() {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have volumeMounts but had :\n  <%s>";
    
    // check
    if (actual.getVolumeMounts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVolumeMounts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ManifestContainer's workingDir is equal to the given one.
   * @param workingDir the given workingDir to compare the actual ManifestContainer's workingDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ManifestContainer's workingDir is not equal to the given one.
   */
  public S hasWorkingDir(String workingDir) {
    // check that actual ManifestContainer we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected workingDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualWorkingDir = actual.getWorkingDir();
    if (!Objects.areEqual(actualWorkingDir, workingDir)) {
      failWithMessage(assertjErrorMessage, actual, workingDir, actualWorkingDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
