package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Manifest} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractManifestAssert<S extends AbstractManifestAssert<S, A>, A extends Manifest> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractManifestAssert}</code> to make assertions on actual Manifest.
   * @param actual the Manifest we want to make assertions on.
   */
  protected AbstractManifestAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Manifest's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Manifest's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Manifest's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Manifest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Manifest's containers contains the given ManifestContainer elements.
   * @param containers the given elements that should be contained in actual Manifest's containers.
   * @return this assertion object.
   * @throws AssertionError if the actual Manifest's containers does not contain all given ManifestContainer elements.
   */
  public S hasContainers(ManifestContainer... containers) {
    // check that actual Manifest we want to make assertions on is not null.
    isNotNull();

    // check that given ManifestContainer varargs is not null.
    if (containers == null) throw new AssertionError("Expecting containers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getContainers(), containers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Manifest has no containers.
   * @return this assertion object.
   * @throws AssertionError if the actual Manifest's containers is not empty.
   */
  public S hasNoContainers() {
    // check that actual Manifest we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have containers but had :\n  <%s>";
    
    // check
    if (actual.getContainers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getContainers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Manifest's version is equal to the given one.
   * @param version the given version to compare the actual Manifest's version to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Manifest's version is not equal to the given one.
   */
  public S hasVersion(Manifest.Version version) {
    // check that actual Manifest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Manifest.Version actualVersion = actual.getVersion();
    if (!Objects.areEqual(actualVersion, version)) {
      failWithMessage(assertjErrorMessage, actual, version, actualVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Manifest's volumes contains the given Volume elements.
   * @param volumes the given elements that should be contained in actual Manifest's volumes.
   * @return this assertion object.
   * @throws AssertionError if the actual Manifest's volumes does not contain all given Volume elements.
   */
  public S hasVolumes(Volume... volumes) {
    // check that actual Manifest we want to make assertions on is not null.
    isNotNull();

    // check that given Volume varargs is not null.
    if (volumes == null) throw new AssertionError("Expecting volumes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVolumes(), volumes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Manifest has no volumes.
   * @return this assertion object.
   * @throws AssertionError if the actual Manifest's volumes is not empty.
   */
  public S hasNoVolumes() {
    // check that actual Manifest we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have volumes but had :\n  <%s>";
    
    // check
    if (actual.getVolumes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVolumes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
