package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Item_} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractItem_Assert<S extends AbstractItem_Assert<S, A>, A extends Item_> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractItem_Assert}</code> to make assertions on actual Item_.
   * @param actual the Item_ we want to make assertions on.
   */
  protected AbstractItem_Assert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Item_'s additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Item_'s additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Item_'s additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Item_ we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Item_'s id is equal to the given one.
   * @param id the given id to compare the actual Item_'s id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Item_'s id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual Item_ we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Item_'s kind is equal to the given one.
   * @param kind the given kind to compare the actual Item_'s kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Item_'s kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Item_ we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
