package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Details} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDetailsAssert<S extends AbstractDetailsAssert<S, A>, A extends Details> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDetailsAssert}</code> to make assertions on actual Details.
   * @param actual the Details we want to make assertions on.
   */
  protected AbstractDetailsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Details's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Details's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Details's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Details we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Details's causes contains the given Cause elements.
   * @param causes the given elements that should be contained in actual Details's causes.
   * @return this assertion object.
   * @throws AssertionError if the actual Details's causes does not contain all given Cause elements.
   */
  public S hasCauses(Cause... causes) {
    // check that actual Details we want to make assertions on is not null.
    isNotNull();

    // check that given Cause varargs is not null.
    if (causes == null) throw new AssertionError("Expecting causes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCauses(), causes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Details has no causes.
   * @return this assertion object.
   * @throws AssertionError if the actual Details's causes is not empty.
   */
  public S hasNoCauses() {
    // check that actual Details we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have causes but had :\n  <%s>";
    
    // check
    if (actual.getCauses().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCauses());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Details's id is equal to the given one.
   * @param id the given id to compare the actual Details's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Details's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual Details we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Details's kind is equal to the given one.
   * @param kind the given kind to compare the actual Details's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Details's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Details we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
