package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CurrentState} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCurrentStateAssert<S extends AbstractCurrentStateAssert<S, A>, A extends CurrentState> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCurrentStateAssert}</code> to make assertions on actual CurrentState.
   * @param actual the CurrentState we want to make assertions on.
   */
  protected AbstractCurrentStateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CurrentState's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CurrentState's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CurrentState's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CurrentState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CurrentState's host is equal to the given one.
   * @param host the given host to compare the actual CurrentState's host to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CurrentState's host is not equal to the given one.
   */
  public S hasHost(String host) {
    // check that actual CurrentState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHost = actual.getHost();
    if (!Objects.areEqual(actualHost, host)) {
      failWithMessage(assertjErrorMessage, actual, host, actualHost);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CurrentState's info is equal to the given one.
   * @param info the given info to compare the actual CurrentState's info to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CurrentState's info is not equal to the given one.
   */
  public S hasInfo(java.util.Map info) {
    // check that actual CurrentState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected info of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualInfo = actual.getInfo();
    if (!Objects.areEqual(actualInfo, info)) {
      failWithMessage(assertjErrorMessage, actual, info, actualInfo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CurrentState's manifest is equal to the given one.
   * @param manifest the given manifest to compare the actual CurrentState's manifest to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CurrentState's manifest is not equal to the given one.
   */
  public S hasManifest(PodContainerManifest manifest) {
    // check that actual CurrentState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected manifest of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodContainerManifest actualManifest = actual.getManifest();
    if (!Objects.areEqual(actualManifest, manifest)) {
      failWithMessage(assertjErrorMessage, actual, manifest, actualManifest);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CurrentState's podIP is equal to the given one.
   * @param podIP the given podIP to compare the actual CurrentState's podIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CurrentState's podIP is not equal to the given one.
   */
  public S hasPodIP(String podIP) {
    // check that actual CurrentState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected podIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPodIP = actual.getPodIP();
    if (!Objects.areEqual(actualPodIP, podIP)) {
      failWithMessage(assertjErrorMessage, actual, podIP, actualPodIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CurrentState's status is equal to the given one.
   * @param status the given status to compare the actual CurrentState's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CurrentState's status is not equal to the given one.
   */
  public S hasStatus(String status) {
    // check that actual CurrentState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
