package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ControllerDesiredState} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractControllerDesiredStateAssert<S extends AbstractControllerDesiredStateAssert<S, A>, A extends ControllerDesiredState> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractControllerDesiredStateAssert}</code> to make assertions on actual ControllerDesiredState.
   * @param actual the ControllerDesiredState we want to make assertions on.
   */
  protected AbstractControllerDesiredStateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ControllerDesiredState's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ControllerDesiredState's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ControllerDesiredState's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ControllerDesiredState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ControllerDesiredState's podTemplate is equal to the given one.
   * @param podTemplate the given podTemplate to compare the actual ControllerDesiredState's podTemplate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ControllerDesiredState's podTemplate is not equal to the given one.
   */
  public S hasPodTemplate(PodTemplate podTemplate) {
    // check that actual ControllerDesiredState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected podTemplate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodTemplate actualPodTemplate = actual.getPodTemplate();
    if (!Objects.areEqual(actualPodTemplate, podTemplate)) {
      failWithMessage(assertjErrorMessage, actual, podTemplate, actualPodTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ControllerDesiredState's replicaSelector is equal to the given one.
   * @param replicaSelector the given replicaSelector to compare the actual ControllerDesiredState's replicaSelector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ControllerDesiredState's replicaSelector is not equal to the given one.
   */
  public S hasReplicaSelector(java.util.Map replicaSelector) {
    // check that actual ControllerDesiredState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected replicaSelector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualReplicaSelector = actual.getReplicaSelector();
    if (!Objects.areEqual(actualReplicaSelector, replicaSelector)) {
      failWithMessage(assertjErrorMessage, actual, replicaSelector, actualReplicaSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ControllerDesiredState's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ControllerDesiredState's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ControllerDesiredState's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ControllerDesiredState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
