package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ControllerCurrentState} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractControllerCurrentStateAssert<S extends AbstractControllerCurrentStateAssert<S, A>, A extends ControllerCurrentState> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractControllerCurrentStateAssert}</code> to make assertions on actual ControllerCurrentState.
   * @param actual the ControllerCurrentState we want to make assertions on.
   */
  protected AbstractControllerCurrentStateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ControllerCurrentState's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ControllerCurrentState's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ControllerCurrentState's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ControllerCurrentState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ControllerCurrentState's podTemplate is equal to the given one.
   * @param podTemplate the given podTemplate to compare the actual ControllerCurrentState's podTemplate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ControllerCurrentState's podTemplate is not equal to the given one.
   */
  public S hasPodTemplate(PodTemplate_ podTemplate) {
    // check that actual ControllerCurrentState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected podTemplate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodTemplate_ actualPodTemplate = actual.getPodTemplate();
    if (!Objects.areEqual(actualPodTemplate, podTemplate)) {
      failWithMessage(assertjErrorMessage, actual, podTemplate, actualPodTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ControllerCurrentState's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ControllerCurrentState's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ControllerCurrentState's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ControllerCurrentState we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
