package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Config} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigAssert<S extends AbstractConfigAssert<S, A>, A extends Config> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigAssert}</code> to make assertions on actual Config.
   * @param actual the Config we want to make assertions on.
   */
  protected AbstractConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Config's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Config's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config's description is equal to the given one.
   * @param description the given description to compare the actual Config's description to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's description is not equal to the given one.
   */
  public S hasDescription(String description) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected description of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDescription = actual.getDescription();
    if (!Objects.areEqual(actualDescription, description)) {
      failWithMessage(assertjErrorMessage, actual, description, actualDescription);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config's id is equal to the given one.
   * @param id the given id to compare the actual Config's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config's items contains the given Item elements.
   * @param items the given elements that should be contained in actual Config's items.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's items does not contain all given Item elements.
   */
  public S hasItems(Item... items) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // check that given Item varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's items is not empty.
   */
  public S hasNoItems() {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Config's kind is equal to the given one.
   * @param kind the given kind to compare the actual Config's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config's name is equal to the given one.
   * @param name the given name to compare the actual Config's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
