package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Cause} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCauseAssert<S extends AbstractCauseAssert<S, A>, A extends Cause> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCauseAssert}</code> to make assertions on actual Cause.
   * @param actual the Cause we want to make assertions on.
   */
  protected AbstractCauseAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Cause's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Cause's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Cause's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Cause we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Cause's field is equal to the given one.
   * @param field the given field to compare the actual Cause's field to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Cause's field is not equal to the given one.
   */
  public S hasField(String field) {
    // check that actual Cause we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected field of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualField = actual.getField();
    if (!Objects.areEqual(actualField, field)) {
      failWithMessage(assertjErrorMessage, actual, field, actualField);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Cause's message is equal to the given one.
   * @param message the given message to compare the actual Cause's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Cause's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual Cause we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Cause's reason is equal to the given one.
   * @param reason the given reason to compare the actual Cause's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Cause's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual Cause we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
