/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.UserConfigurationCompare;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplaceable;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftNotAvailableException;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.openshift.client.dsl.ClientTemplateResource;
import io.fabric8.utils.Files;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Controller {
    private static final transient Logger LOG = LoggerFactory.getLogger(Controller.class);
    private final KubernetesClient kubernetesClient;
    private boolean throwExceptionOnError = true;
    private boolean allowCreate = true;
    private boolean recreateMode;
    private boolean servicesOnlyMode;
    private boolean ignoreServiceMode;
    private boolean ignoreRunningOAuthClients = true;
    private boolean rollingUpgrade;
    private boolean processTemplatesLocally;
    private File logJsonDir;
    private File basedir;
    private boolean failOnMissingParameterValue;
    private boolean supportOAuthClients;
    private boolean deletePodsOnReplicationControllerUpdate = true;
    private String namesapce = KubernetesHelper.defaultNamespace();
    private boolean requireSecretsCreatedBeforeReplicationControllers;
    private boolean rollingUpgradePreserveScale = true;

    public Controller() {
        this((KubernetesClient)new DefaultKubernetesClient());
    }

    public Controller(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public String apply(File file) throws Exception {
        String ext = Files.getFileExtension((File)file);
        if ("yaml".equalsIgnoreCase(ext)) {
            return this.applyYaml(file);
        }
        if ("json".equalsIgnoreCase(ext)) {
            return this.applyJson(file);
        }
        throw new IllegalArgumentException("Unknown file type " + ext);
    }

    public String applyJson(byte[] json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(String json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(File json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(String yaml) throws Exception {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(File yaml) throws Exception {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    private String convertYamlToJson(String yamlString) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(yamlString);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    private String convertYamlToJson(File yamlFile) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        FileInputStream fstream = new FileInputStream(yamlFile);
        Map map = (Map)yaml.load((InputStream)fstream);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    public String applyJson(InputStream json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public void apply(Object dto, String sourceName) throws Exception {
        if (dto instanceof List) {
            List list = (List)dto;
            for (Object element : list) {
                if (dto == element) {
                    LOG.warn("Found recursive nested object for " + dto + " of class: " + dto.getClass().getName());
                    continue;
                }
                this.apply(element, sourceName);
            }
        } else if (dto instanceof KubernetesList) {
            this.applyList((KubernetesList)dto, sourceName);
        } else if (dto != null) {
            this.applyEntity(dto, sourceName);
        }
    }

    public void applyEntity(Object dto, String sourceName) throws Exception {
        if (dto instanceof Pod) {
            this.applyPod((Pod)dto, sourceName);
        } else if (dto instanceof ReplicationController) {
            this.applyReplicationController((ReplicationController)dto, sourceName);
        } else if (dto instanceof Service) {
            this.applyService((Service)dto, sourceName);
        } else if (dto instanceof Namespace) {
            this.applyNamespace((Namespace)dto);
        } else if (dto instanceof Route) {
            this.applyRoute((Route)dto, sourceName);
        } else if (dto instanceof BuildConfig) {
            this.applyBuildConfig((BuildConfig)dto, sourceName);
        } else if (dto instanceof DeploymentConfig) {
            this.applyDeploymentConfig((DeploymentConfig)dto, sourceName);
        } else if (dto instanceof ImageStream) {
            this.applyImageStream((ImageStream)dto, sourceName);
        } else if (dto instanceof OAuthClient) {
            this.applyOAuthClient((OAuthClient)dto, sourceName);
        } else if (dto instanceof PersistentVolumeClaim) {
            this.applyResource((HasMetadata)((PersistentVolumeClaim)dto), sourceName, (ClientOperation)this.kubernetesClient.persistentVolumeClaims());
        } else if (dto instanceof Template) {
            this.applyTemplate((Template)dto, sourceName);
        } else if (dto instanceof ServiceAccount) {
            this.applyServiceAccount((ServiceAccount)dto, sourceName);
        } else if (dto instanceof Secret) {
            this.applySecret((Secret)dto, sourceName);
        } else if (dto instanceof DaemonSet) {
            this.applyResource((HasMetadata)((DaemonSet)dto), sourceName, (ClientOperation)this.kubernetesClient.extensions().daemonSets());
        } else {
            throw new IllegalArgumentException("Unknown entity type " + dto);
        }
    }

    public void applyOAuthClient(OAuthClient entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null && this.supportOAuthClients) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            if (this.isServicesOnlyMode()) {
                LOG.debug("Only processing Services right now so ignoring OAuthClient: " + id);
                return;
            }
            OAuthClient old = (OAuthClient)((ClientResource)openShiftClient.oAuthClients().withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (this.isIgnoreRunningOAuthClients()) {
                    LOG.info("Not updating the OAuthClient which are shared across namespaces as its already running");
                    return;
                }
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("OAuthClient has not changed so not doing anything");
                } else if (this.isRecreateMode()) {
                    ((ClientResource)openShiftClient.oAuthClients().withName(id)).delete();
                    this.doCreateOAuthClient(entity, sourceName);
                } else {
                    try {
                        Object answer = ((ClientResource)openShiftClient.oAuthClients().withName(id)).replace((Object)entity);
                        LOG.info("Updated OAuthClient result: " + answer);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating an OAuthClient from " + sourceName + " name " + KubernetesHelper.getName((HasMetadata)entity));
            } else {
                this.doCreateOAuthClient(entity, sourceName);
            }
        }
    }

    protected void doCreateOAuthClient(OAuthClient entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null) {
            Object result = null;
            try {
                result = openShiftClient.oAuthClients().create((Object[])new OAuthClient[]{entity});
            }
            catch (Exception e) {
                this.onApplyError("Failed to create OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public Object applyTemplate(Template entity, String sourceName) throws Exception {
        this.installTemplate(entity, sourceName);
        return this.processTemplate(entity, sourceName);
    }

    public void installTemplate(Template entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient == null) {
            return;
        }
        if (!this.isProcessTemplatesLocally()) {
            String namespace = this.getNamespace();
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            Template old = (Template)((ClientTemplateResource)((ClientNonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("Template has not changed so not doing anything");
                } else {
                    boolean recreateMode = this.isRecreateMode();
                    recreateMode = true;
                    if (recreateMode) {
                        ((ClientTemplateResource)((ClientNonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).withName(id)).delete();
                        this.doCreateTemplate(entity, namespace, sourceName);
                    } else {
                        LOG.info("Updating a Template from " + sourceName);
                        try {
                            Object answer = ((ClientTemplateResource)((ClientNonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).withName(id)).replace((Object)entity);
                            LOG.info("Updated Template: " + answer);
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update Template from " + sourceName + ". " + e + ". " + entity, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating a Template from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity));
            } else {
                this.doCreateTemplate(entity, namespace, sourceName);
            }
        }
    }

    public OpenShiftClient getOpenShiftClientOrNull() {
        OpenShiftClient openShiftClient = null;
        try {
            openShiftClient = (OpenShiftClient)this.kubernetesClient.adapt(OpenShiftClient.class);
        }
        catch (OpenShiftNotAvailableException openShiftNotAvailableException) {
            // empty catch block
        }
        return openShiftClient;
    }

    public OpenShiftClient getOpenShiftClientOrJenkinshift() {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient == null) {
            String jenkinshiftUrl = Systems.getEnvVar((String)"JENKINSHIFT_URL", (String)"http://jenkinshift/");
            openShiftClient = new DefaultOpenShiftClient(jenkinshiftUrl);
        }
        return openShiftClient;
    }

    protected void doCreateTemplate(Template entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null) {
            LOG.info("Creating a Template from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity));
            try {
                Object answer = ((ClientNonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).create((Object[])new Template[]{entity});
                this.logGeneratedEntity("Created Template: ", namespace, (HasMetadata)entity, answer);
            }
            catch (Exception e) {
                this.onApplyError("Failed to Template entity from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public void applyServiceAccount(ServiceAccount serviceAccount, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)serviceAccount);
        Objects.notNull((Object)id, (String)("No name for " + serviceAccount + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring ServiceAccount: " + id);
            return;
        }
        ServiceAccount old = (ServiceAccount)((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(serviceAccount, old)) {
                LOG.info("ServiceAccount has not changed so not doing anything");
            } else if (this.isRecreateMode()) {
                ((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).withName(id)).delete();
                this.doCreateServiceAccount(serviceAccount, namespace, sourceName);
            } else {
                LOG.info("Updating a ServiceAccount from " + sourceName);
                try {
                    Object answer = ((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).withName(id)).replace((Object)serviceAccount);
                    this.logGeneratedEntity("Updated ServiceAccount: ", namespace, (HasMetadata)serviceAccount, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update ServiceAccount from " + sourceName + ". " + e + ". " + serviceAccount, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a ServiceAccount from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)serviceAccount));
        } else {
            this.doCreateServiceAccount(serviceAccount, namespace, sourceName);
        }
    }

    protected void doCreateServiceAccount(ServiceAccount serviceAccount, String namespace, String sourceName) {
        LOG.info("Creating a ServiceAccount from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)serviceAccount));
        try {
            Object answer = Strings.isNotBlank((String)namespace) ? ((ClientNonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).create((Object[])new ServiceAccount[]{serviceAccount}) : ((ClientNonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(this.getNamespace())).create((Object[])new ServiceAccount[]{serviceAccount});
            this.logGeneratedEntity("Created ServiceAccount: ", namespace, (HasMetadata)serviceAccount, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create ServiceAccount from " + sourceName + ". " + e + ". " + serviceAccount, e);
        }
    }

    public void applySecret(Secret secret, String sourceName) throws Exception {
        String namespace = this.getNamespace((HasMetadata)secret);
        String id = KubernetesHelper.getName((HasMetadata)secret);
        Objects.notNull((Object)id, (String)("No name for " + secret + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring Secrets: " + id);
            return;
        }
        Secret old = (Secret)((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(secret, old)) {
                LOG.info("Secret has not changed so not doing anything");
                return;
            }
            if (this.isRecreateMode()) {
                ((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).withName(id)).delete();
                this.doCreateSecret(secret, namespace, sourceName);
            } else {
                LOG.info("Updating a Secret from " + sourceName);
                try {
                    Object answer = ((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).withName(id)).replace((Object)secret);
                    this.logGeneratedEntity("Updated Secret:", namespace, (HasMetadata)secret, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update secret from " + sourceName + ". " + e + ". " + secret, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a Secret from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)secret));
        } else {
            this.doCreateSecret(secret, namespace, sourceName);
        }
    }

    protected void doCreateSecret(Secret secret, String namespace, String sourceName) {
        LOG.info("Creating a Secret from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)secret));
        try {
            Object answer = Strings.isNotBlank((String)namespace) ? ((ClientNonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).create((Object[])new Secret[]{secret}) : ((ClientNonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(this.getNamespace())).create((Object[])new Secret[]{secret});
            this.logGeneratedEntity("Created Secret: ", namespace, (HasMetadata)secret, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Secret from " + sourceName + ". " + e + ". " + secret, e);
        }
    }

    protected void logGeneratedEntity(String message, String namespace, HasMetadata entity, Object result) {
        if (this.logJsonDir != null) {
            File namespaceDir = new File(this.logJsonDir, namespace);
            namespaceDir.mkdirs();
            String kind = KubernetesHelper.getKind(entity);
            String name = KubernetesHelper.getName(entity);
            if (Strings.isNotBlank((String)kind)) {
                name = kind.toLowerCase() + "-" + name;
            }
            if (Strings.isNullOrBlank((String)name)) {
                LOG.warn("No name for the entity " + entity);
            } else {
                String text;
                String fileName = name + ".json";
                File file = new File(namespaceDir, fileName);
                if (file.exists()) {
                    int idx = 1;
                    while ((file = new File(namespaceDir, fileName = name + "-" + idx++ + ".json")).exists()) {
                    }
                }
                if (result instanceof String) {
                    text = result.toString();
                } else {
                    try {
                        text = KubernetesHelper.toJson(result);
                    }
                    catch (JsonProcessingException e) {
                        LOG.warn("Cannot convert " + result + " to JSON: " + (Object)((Object)e), (Throwable)e);
                        text = result != null ? result.toString() : "null";
                    }
                }
                try {
                    String path;
                    IOHelpers.writeFully((File)file, (String)text);
                    Object fileLocation = file;
                    if (this.basedir != null && (path = Files.getRelativePath((File)this.basedir, (File)file)) != null) {
                        fileLocation = Strings.stripPrefix((String)path, (String)"/");
                    }
                    LOG.info(message + fileLocation);
                }
                catch (IOException e) {
                    LOG.warn("Failed to write to file " + file + ". " + e, (Throwable)e);
                }
                return;
            }
        }
        LOG.info(message + result);
    }

    public Object processTemplate(Template entity, String sourceName) {
        try {
            return Templates.processTemplatesLocally(entity, this.failOnMissingParameterValue);
        }
        catch (IOException e) {
            this.onApplyError("Failed to process template " + sourceName + ". " + e + ". " + entity, e);
            return null;
        }
    }

    protected void printSummary(Object kubeResource) throws IOException {
        if (kubeResource != null) {
            LOG.debug("  " + kubeResource.getClass().getSimpleName() + " " + kubeResource);
        }
        if (kubeResource instanceof Template) {
            Template template = (Template)kubeResource;
            String id = KubernetesHelper.getName((HasMetadata)template);
            LOG.info("  Template " + id + " " + KubernetesHelper.summaryText(template));
            this.printSummary(template.getObjects());
            return;
        }
        List<HasMetadata> list = KubernetesHelper.toItemList(kubeResource);
        for (HasMetadata object : list) {
            if (object == null) continue;
            if (object == list) {
                LOG.debug("Ignoring recursive list " + list);
                continue;
            }
            if (object instanceof List) {
                this.printSummary(object);
                continue;
            }
            String kind = object.getClass().getSimpleName();
            String id = KubernetesHelper.getObjectId(object);
            LOG.info("    " + kind + " " + id + " " + KubernetesHelper.summaryText(object));
        }
    }

    public void applyRoute(Route entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null) {
            Route route;
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
            if (Strings.isNullOrBlank((String)namespace)) {
                namespace = this.getNamespace();
            }
            if ((route = (Route)((ClientResource)((ClientNonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(id)).get()) == null) {
                try {
                    LOG.info("Creating Route " + namespace + ":" + id + " " + KubernetesHelper.summaryText(entity));
                    ((ClientNonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).create((Object[])new Route[]{entity});
                }
                catch (Exception e) {
                    this.onApplyError("Failed to create Route from " + sourceName + ". " + e + ". " + entity, e);
                }
            }
        }
    }

    public void applyBuildConfig(BuildConfig entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrJenkinshift();
        if (openShiftClient != null) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
            if (Strings.isNullOrBlank((String)namespace)) {
                namespace = this.getNamespace();
            }
            this.applyNamespace(namespace);
            BuildConfig old = (BuildConfig)((ClientBuildConfigResource)((ClientNonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("BuildConfig has not changed so not doing anything");
                } else if (this.isRecreateMode()) {
                    LOG.info("Deleting BuildConfig: " + id);
                    ((ClientBuildConfigResource)((ClientNonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(id)).delete();
                    this.doCreateBuildConfig(entity, namespace, sourceName);
                } else {
                    LOG.info("Updating BuildConfig from " + sourceName);
                    try {
                        String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)old);
                        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
                        metadata.setNamespace(namespace);
                        metadata.setResourceVersion(resourceVersion);
                        Object answer = ((ClientBuildConfigResource)((ClientNonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(id)).replace((Object)entity);
                        this.logGeneratedEntity("Updated BuildConfig: ", namespace, (HasMetadata)entity, answer);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update BuildConfig from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating BuildConfig from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity));
            } else {
                this.doCreateBuildConfig(entity, namespace, sourceName);
            }
        }
    }

    public void doCreateBuildConfig(BuildConfig entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrJenkinshift();
        if (openShiftClient != null) {
            try {
                ((ClientNonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).create((Object[])new BuildConfig[]{entity});
            }
            catch (Exception e) {
                this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyDeploymentConfig(DeploymentConfig entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null) {
            try {
                ((ClientNonNamespaceOperation)openShiftClient.deploymentConfigs().inNamespace(this.getNamespace())).create((Object[])new DeploymentConfig[]{entity});
            }
            catch (Exception e) {
                this.onApplyError("Failed to create DeploymentConfig from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyImageStream(ImageStream entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null) {
            try {
                ((ClientNonNamespaceOperation)openShiftClient.imageStreams().inNamespace(this.getNamespace())).create((Object[])new ImageStream[]{entity});
            }
            catch (Exception e) {
                this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyList(KubernetesList list, String sourceName) throws Exception {
        List entities = list.getItems();
        if (entities != null) {
            for (Object entity : entities) {
                this.applyEntity(entity, sourceName);
            }
        }
    }

    public void applyService(Service service, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)service);
        Objects.notNull((Object)id, (String)("No name for " + service + " " + sourceName));
        if (this.isIgnoreServiceMode()) {
            LOG.debug("Ignoring Service: " + namespace + ":" + id);
            return;
        }
        Service old = (Service)((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(service, old)) {
                LOG.info("Service has not changed so not doing anything");
            } else if (this.isRecreateMode()) {
                LOG.info("Deleting Service: " + id);
                ((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(id)).delete();
                this.doCreateService(service, namespace, sourceName);
            } else {
                LOG.info("Updating a Service from " + sourceName);
                try {
                    Object answer = ((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(id)).replace((Object)service);
                    this.logGeneratedEntity("Updated Service: ", namespace, (HasMetadata)service, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update Service from " + sourceName + ". " + e + ". " + service, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a Service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)service));
        } else {
            this.doCreateService(service, namespace, sourceName);
        }
    }

    public <T extends HasMetadata, L, D> void applyResource(T resource, String sourceName, ClientOperation<T, L, D, ClientResource<T, D>> resources) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName(resource);
        String kind = KubernetesHelper.getKind(resource);
        Objects.notNull((Object)id, (String)("No name for " + resource + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Ignoring " + kind + ": " + namespace + ":" + id);
            return;
        }
        HasMetadata old = (HasMetadata)((ClientResource)((ClientNonNamespaceOperation)resources.inNamespace(namespace)).withName(id)).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(resource, old)) {
                LOG.info(kind + " has not changed so not doing anything");
            } else if (this.isRecreateMode()) {
                LOG.info("Deleting " + kind + ": " + id);
                ((ClientResource)((ClientNonNamespaceOperation)resources.inNamespace(namespace)).withName(id)).delete();
                this.doCreateResource(resource, namespace, sourceName, resources);
            } else {
                LOG.info("Updating " + kind + " from " + sourceName);
                try {
                    Object answer = ((ClientResource)((ClientNonNamespaceOperation)resources.inNamespace(namespace)).withName(id)).replace(resource);
                    this.logGeneratedEntity("Updated " + kind + ": ", namespace, resource, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update " + kind + " from " + sourceName + ". " + e + ". " + resource, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a " + kind + " from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(resource));
        } else {
            this.doCreateResource(resource, namespace, sourceName, resources);
        }
    }

    protected <T extends HasMetadata, L, D> void doCreateResource(T resource, String namespace, String sourceName, ClientOperation<T, L, D, ClientResource<T, D>> resources) throws Exception {
        String kind = KubernetesHelper.getKind(resource);
        LOG.info("Creating a " + kind + " from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(resource));
        try {
            Object answer = Strings.isNotBlank((String)namespace) ? ((ClientNonNamespaceOperation)resources.inNamespace(namespace)).create((Object[])new HasMetadata[]{resource}) : ((ClientNonNamespaceOperation)resources.inNamespace(this.getNamespace())).create((Object[])new HasMetadata[]{resource});
            this.logGeneratedEntity("Created " + kind + ": ", namespace, resource, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create " + kind + " from " + sourceName + ". " + e + ". " + resource, e);
        }
    }

    protected void doCreateService(Service service, String namespace, String sourceName) {
        LOG.info("Creating a Service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)service));
        try {
            Object answer = Strings.isNotBlank((String)namespace) ? ((ClientNonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).create((Object[])new Service[]{service}) : ((ClientNonNamespaceOperation)this.kubernetesClient.services().inNamespace(this.getNamespace())).create((Object[])new Service[]{service});
            this.logGeneratedEntity("Created Service: ", namespace, (HasMetadata)service, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Service from " + sourceName + ". " + e + ". " + service, e);
        }
    }

    public void applyNamespace(String namespaceName) {
        Namespace entity = new Namespace();
        KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).setName(namespaceName);
        this.applyNamespace(entity);
    }

    public boolean applyNamespace(Namespace entity) {
        String namespace = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).getName();
        LOG.info("Using namespace: " + namespace);
        String name = KubernetesHelper.getName((HasMetadata)entity);
        Objects.notNull((Object)name, (String)("No name for " + entity));
        Namespace old = (Namespace)((ClientResource)this.kubernetesClient.namespaces().withName(name)).get();
        if (!this.isRunning((HasMetadata)old)) {
            try {
                Object answer = this.kubernetesClient.namespaces().create((Object[])new Namespace[]{entity});
                this.logGeneratedEntity("Created namespace: ", namespace, (HasMetadata)entity, answer);
                return true;
            }
            catch (Exception e) {
                this.onApplyError("Failed to create namespace: " + name + " due " + e.getMessage(), e);
            }
        }
        return false;
    }

    public void applyReplicationController(ReplicationController replicationController, String sourceName) throws Exception {
        block15: {
            String namespace = this.getNamespace();
            String id = KubernetesHelper.getName((HasMetadata)replicationController);
            Objects.notNull((Object)id, (String)("No name for " + replicationController + " " + sourceName));
            if (this.isServicesOnlyMode()) {
                LOG.debug("Only processing Services right now so ignoring ReplicationController: " + namespace + ":" + id);
                return;
            }
            ReplicationController old = (ReplicationController)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(replicationController, old)) {
                    LOG.info("ReplicationController has not changed so not doing anything");
                } else {
                    ReplicationControllerSpec newSpec = replicationController.getSpec();
                    ReplicationControllerSpec oldSpec = old.getSpec();
                    if (this.rollingUpgrade) {
                        Integer replicas;
                        LOG.info("Rolling upgrade of the ReplicationController: " + namespace + "/" + id);
                        if (this.rollingUpgradePreserveScale && newSpec != null && oldSpec != null && (replicas = oldSpec.getReplicas()) != null) {
                            newSpec.setReplicas(replicas);
                        }
                        LOG.info("rollingUpgradePreserveScale " + this.rollingUpgradePreserveScale + " new replicas is " + (newSpec != null ? newSpec.getReplicas() : "<null>"));
                        ((TimeoutImageEditReplaceable)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).rolling()).replace((Object)replicationController);
                    } else if (this.isRecreateMode()) {
                        LOG.info("Deleting ReplicationController: " + id);
                        ((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).delete();
                        this.doCreateReplicationController(replicationController, namespace, sourceName);
                    } else {
                        LOG.info("Updating ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController));
                        try {
                            Object answer = ((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).replace((Object)replicationController);
                            this.logGeneratedEntity("Updated replicationController: ", namespace, (HasMetadata)replicationController, answer);
                            if (this.deletePodsOnReplicationControllerUpdate) {
                                ((FilterWatchListDeletable)((ClientNonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withLabels(newSpec.getSelector())).delete();
                                LOG.info("Deleting any pods for the replication controller to ensure they use the new configuration");
                                break block15;
                            }
                            LOG.info("Warning not deleted any pods so they could well be running with the old configuration!");
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update ReplicationController from " + sourceName + ". " + e + ". " + replicationController, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating a ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController));
            } else {
                this.doCreateReplicationController(replicationController, namespace, sourceName);
            }
        }
    }

    protected void doCreateReplicationController(ReplicationController replicationController, String namespace, String sourceName) {
        LOG.info("Creating a ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController));
        try {
            PodTemplateSpec template;
            ReplicationControllerSpec spec = replicationController.getSpec();
            if (spec != null && (template = spec.getTemplate()) != null) {
                PodSpec podSpec = template.getSpec();
                this.validatePodSpec(podSpec, namespace);
            }
            Object answer = Strings.isNotBlank((String)namespace) ? ((ClientNonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).create((Object[])new ReplicationController[]{replicationController}) : ((ClientNonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(this.getNamespace())).create((Object[])new ReplicationController[]{replicationController});
            this.logGeneratedEntity("Created ReplicationController: ", namespace, (HasMetadata)replicationController, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create ReplicationController from " + sourceName + ". " + e + ". " + replicationController, e);
        }
    }

    protected void validatePodSpec(PodSpec podSpec, String namespace) {
        List volumes;
        if (this.requireSecretsCreatedBeforeReplicationControllers && (volumes = podSpec.getVolumes()) != null) {
            for (Volume volume : volumes) {
                String secretName;
                SecretVolumeSource secret = volume.getSecret();
                if (secret == null || !Strings.isNotBlank((String)(secretName = secret.getSecretName()))) continue;
                KubernetesHelper.validateSecretExists(this.kubernetesClient, namespace, secretName);
            }
        }
    }

    public void applyPod(Pod pod, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName((HasMetadata)pod);
        Objects.notNull((Object)id, (String)("No name for " + pod + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring Pod: " + namespace + ":" + id);
            return;
        }
        Pod old = (Pod)((ClientPodResource)((ClientNonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual(pod, old)) {
                LOG.info("Pod has not changed so not doing anything");
            } else if (this.isRecreateMode()) {
                LOG.info("Deleting Pod: " + id);
                ((ClientPodResource)((ClientNonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withName(id)).delete();
                this.doCreatePod(pod, namespace, sourceName);
            } else {
                LOG.info("Updating a Pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod));
                try {
                    Object answer = ((ClientPodResource)((ClientNonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withName(id)).replace((Object)pod);
                    LOG.info("Updated Pod result: " + answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update Pod from " + sourceName + ". " + e + ". " + pod, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod));
        } else {
            this.doCreatePod(pod, namespace, sourceName);
        }
    }

    protected void doCreatePod(Pod pod, String namespace, String sourceName) {
        LOG.info("Creating a Pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod));
        try {
            PodSpec podSpec = pod.getSpec();
            if (podSpec != null) {
                this.validatePodSpec(podSpec, namespace);
            }
            Object answer = Strings.isNotBlank((String)namespace) ? ((ClientNonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).create((Object[])new Pod[]{pod}) : ((ClientNonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.getNamespace())).create((Object[])new Pod[]{pod});
            LOG.info("Created Pod result: " + answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Pod from " + sourceName + ". " + e + ". " + pod, e);
        }
    }

    public String getNamespace() {
        return this.namesapce;
    }

    protected String getNamespace(HasMetadata entity) {
        String answer = KubernetesHelper.getNamespace(entity);
        if (Strings.isNullOrBlank((String)answer)) {
            answer = this.getNamespace();
        }
        this.applyNamespace(answer);
        return answer;
    }

    public void setNamespace(String namespace) {
        this.namesapce = namespace;
    }

    public boolean isThrowExceptionOnError() {
        return this.throwExceptionOnError;
    }

    public void setThrowExceptionOnError(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    public boolean isProcessTemplatesLocally() {
        return this.processTemplatesLocally;
    }

    public void setProcessTemplatesLocally(boolean processTemplatesLocally) {
        this.processTemplatesLocally = processTemplatesLocally;
    }

    public boolean isDeletePodsOnReplicationControllerUpdate() {
        return this.deletePodsOnReplicationControllerUpdate;
    }

    public void setDeletePodsOnReplicationControllerUpdate(boolean deletePodsOnReplicationControllerUpdate) {
        this.deletePodsOnReplicationControllerUpdate = deletePodsOnReplicationControllerUpdate;
    }

    public File getLogJsonDir() {
        return this.logJsonDir;
    }

    public void setLogJsonDir(File logJsonDir) {
        this.logJsonDir = logJsonDir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    protected boolean isRunning(HasMetadata entity) {
        return entity != null;
    }

    protected void onApplyError(String message, Exception e) {
        LOG.error(message, (Throwable)e);
        if (this.throwExceptionOnError) {
            throw new RuntimeException(message, e);
        }
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setRecreateMode(boolean recreateMode) {
        this.recreateMode = recreateMode;
    }

    public void setServicesOnlyMode(boolean servicesOnlyMode) {
        this.servicesOnlyMode = servicesOnlyMode;
    }

    public boolean isServicesOnlyMode() {
        return this.servicesOnlyMode;
    }

    public boolean isIgnoreServiceMode() {
        return this.ignoreServiceMode;
    }

    public void setIgnoreServiceMode(boolean ignoreServiceMode) {
        this.ignoreServiceMode = ignoreServiceMode;
    }

    public boolean isIgnoreRunningOAuthClients() {
        return this.ignoreRunningOAuthClients;
    }

    public void setIgnoreRunningOAuthClients(boolean ignoreRunningOAuthClients) {
        this.ignoreRunningOAuthClients = ignoreRunningOAuthClients;
    }

    public boolean isFailOnMissingParameterValue() {
        return this.failOnMissingParameterValue;
    }

    public void setFailOnMissingParameterValue(boolean failOnMissingParameterValue) {
        this.failOnMissingParameterValue = failOnMissingParameterValue;
    }

    public boolean isSupportOAuthClients() {
        return this.supportOAuthClients;
    }

    public void setSupportOAuthClients(boolean supportOAuthClients) {
        this.supportOAuthClients = supportOAuthClients;
    }

    public boolean isRequireSecretsCreatedBeforeReplicationControllers() {
        return this.requireSecretsCreatedBeforeReplicationControllers;
    }

    public void setRequireSecretsCreatedBeforeReplicationControllers(boolean requireSecretsCreatedBeforeReplicationControllers) {
        this.requireSecretsCreatedBeforeReplicationControllers = requireSecretsCreatedBeforeReplicationControllers;
    }

    public boolean isRollingUpgrade() {
        return this.rollingUpgrade;
    }

    public void setRollingUpgrade(boolean rollingUpgrade) {
        this.rollingUpgrade = rollingUpgrade;
    }

    public boolean isRollingUpgradePreserveScale() {
        return this.rollingUpgradePreserveScale;
    }

    public void setRollingUpgradePreserveScale(boolean rollingUpgradePreserveScale) {
        this.rollingUpgradePreserveScale = rollingUpgradePreserveScale;
    }
}

