/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.fabric8.kubernetes.api.ExceptionResponseMapper;
import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesExtensions;
import io.fabric8.kubernetes.api.KubernetesGlobalExtensions;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.support.KindToClassMapping;
import io.fabric8.kubernetes.api.support.KubernetesDeserializer;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.AuthorizationHeaderFilter;
import io.fabric8.utils.cxf.WebClients;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesFactory {
    public static final String KUBERNETES_SCHEMA_JSON = "schema/kube-schema.json";
    public static final String OPENSHIFT_CONFIG_FILE_PROPERTY = "openshift.config.file";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_KUBERNETES_MASTER = "http://localhost:8080";
    public static final String KUBERNETES_TRUST_ALL_CERIFICATES = "KUBERNETES_TRUST_CERT";
    public static final String KUBERNETES_SERVICE_HOST_ENV_VAR = "KUBERNETES_SERVICE_HOST";
    public static final String KUBERNETES_SERVICE_PORT_ENV_VAR = "KUBERNETES_SERVICE_PORT";
    public static final String KUBERNETES_RO_SERVICE_HOST_ENV_VAR = "KUBERNETES_RO_SERVICE_HOST";
    public static final String KUBERNETES_RO_SERVICE_PORT_ENV_VAR = "KUBERNETES_RO_SERVICE_PORT";
    public static final String KUBERNETES_MASTER_ENV_VAR = "KUBERNETES_MASTER";
    public static final String KUBERNETES_CA_CERTIFICATE_FILE_ENV_VAR = "KUBERNETES_CA_CERTIFICATE_FILE";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_FILE_ENV_VAR = "KUBERNETES_CLIENT_CERTIFICATE_FILE";
    public static final String KUBERNETES_CLIENT_KEY_FILE_ENV_VAR = "KUBERNETES_CLIENT_KEY_FILE";
    public static final String KUBERNETES_CLIENT_KEY_DATA_ENV_VAR = "KUBERNETES_CLIENT_KEY_DATA";
    public static final String KUBERNETES_CA_CERTIFICATE_DATA_ENV_VAR = "KUBERNETES_CA_CERTIFICATE_DATA";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_DATA_ENV_VAR = "KUBERNETES_CLIENT_CERTIFICATE_DATA";
    public static final String KUBERNETES_CLIENT_KEY_ALGO_ENV_VAR = "KUBERNETES_CLIENT_KEY_ALGO";
    public static final String KUBERNETES_CLIENT_KEY_PASSWORD_ENV_VAR = "KUBERNETES_CLIENT_KEY_PASSWORD";
    public static final String KUBERNETES_MASTER_SYSTEM_PROPERTY = "kubernetes.master";
    private String address;
    private boolean verifyAddress = true;
    private boolean trustAllCerts = false;
    private File caCertFile;
    private File clientCertFile;
    private File clientKeyFile;
    private String caCertData;
    private String clientCertData;
    private String clientKeyData;
    private String clientKeyAlgo = "RSA";
    private char[] clientKeyPassword = new char[0];
    private String username;
    private String password;

    public KubernetesFactory() {
        this(null);
    }

    public KubernetesFactory(boolean writeable) {
        this(null, writeable);
    }

    public KubernetesFactory(String address) {
        this(address, false);
    }

    public KubernetesFactory(String address, boolean writeable) {
        this.init();
        this.initAddress(address, writeable);
    }

    public KubernetesFactory(String address, boolean writeable, boolean verifyAddress) {
        this.verifyAddress = verifyAddress;
        this.init();
        this.initAddress(address, writeable);
    }

    protected void initAddress(String address, boolean writeable) {
        if (Strings.isNullOrBlank((String)address)) {
            this.setAddress(this.findKubernetesMaster(writeable));
        } else {
            this.setAddress(address);
        }
    }

    protected String findKubernetesMaster() {
        return this.findKubernetesMaster(false);
    }

    protected String findKubernetesMaster(boolean writeable) {
        return KubernetesFactory.resolveHttpKubernetesMaster(writeable);
    }

    private void init() {
        if (System.getenv(KUBERNETES_TRUST_ALL_CERIFICATES) != null) {
            this.trustAllCerts = Boolean.valueOf(System.getenv(KUBERNETES_TRUST_ALL_CERIFICATES));
        } else if (System.getenv(KUBERNETES_CA_CERTIFICATE_FILE_ENV_VAR) != null) {
            File candidateCaCertFile = new File(System.getenv(KUBERNETES_CA_CERTIFICATE_FILE_ENV_VAR));
            if (candidateCaCertFile.exists() && candidateCaCertFile.canRead()) {
                this.caCertFile = candidateCaCertFile;
            } else {
                this.log.error("Specified CA certificate file {} does not exist or is not readable", (Object)candidateCaCertFile);
            }
        }
        if (System.getenv(KUBERNETES_CA_CERTIFICATE_DATA_ENV_VAR) != null) {
            this.caCertData = System.getenv(KUBERNETES_CA_CERTIFICATE_DATA_ENV_VAR);
        }
        if (System.getenv(KUBERNETES_CLIENT_CERTIFICATE_FILE_ENV_VAR) != null) {
            File candidateClientCertFile = new File(System.getenv(KUBERNETES_CLIENT_CERTIFICATE_FILE_ENV_VAR));
            if (candidateClientCertFile.exists() && candidateClientCertFile.canRead()) {
                this.clientCertFile = candidateClientCertFile;
            } else {
                this.log.error("Specified client certificate file {} does not exist or is not readable", (Object)candidateClientCertFile);
            }
        }
        if (System.getenv(KUBERNETES_CLIENT_CERTIFICATE_DATA_ENV_VAR) != null) {
            this.clientCertData = System.getenv(KUBERNETES_CLIENT_CERTIFICATE_DATA_ENV_VAR);
        }
        if (System.getenv(KUBERNETES_CLIENT_KEY_FILE_ENV_VAR) != null) {
            File candidateClientKeyFile = new File(System.getenv(KUBERNETES_CLIENT_KEY_FILE_ENV_VAR));
            if (candidateClientKeyFile.exists() && candidateClientKeyFile.canRead()) {
                this.clientKeyFile = candidateClientKeyFile;
            } else {
                this.log.error("Specified client key file {} does not exist or is not readable", (Object)candidateClientKeyFile);
            }
        }
        if (System.getenv(KUBERNETES_CLIENT_KEY_DATA_ENV_VAR) != null) {
            this.clientKeyData = System.getenv(KUBERNETES_CLIENT_KEY_DATA_ENV_VAR);
        }
        if (System.getenv(KUBERNETES_CLIENT_KEY_ALGO_ENV_VAR) != null) {
            this.clientKeyAlgo = System.getenv(KUBERNETES_CLIENT_KEY_ALGO_ENV_VAR);
        }
        if (System.getenv(KUBERNETES_CLIENT_KEY_PASSWORD_ENV_VAR) != null) {
            this.clientKeyPassword = System.getenv(KUBERNETES_CLIENT_KEY_PASSWORD_ENV_VAR).toCharArray();
        }
    }

    public String toString() {
        return "KubernetesFactory{" + this.address + '}';
    }

    public Kubernetes createKubernetes() {
        return this.createWebClient(Kubernetes.class);
    }

    public KubernetesExtensions createKubernetesExtensions() {
        return this.createWebClient(KubernetesExtensions.class);
    }

    public KubernetesGlobalExtensions createKubernetesGlobalExtensions() {
        return this.createWebClient(KubernetesGlobalExtensions.class);
    }

    public <T> T createWebClient(Class<T> clientType) {
        WebClient webClient = this.createWebClient();
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clientType);
    }

    public WebClient createWebClient() {
        return this.createWebClient(this.address);
    }

    public WebClient createWebClient(String serviceAddress) {
        String token;
        List<Object> providers = this.createProviders();
        AuthorizationHeaderFilter authorizationHeaderFilter = new AuthorizationHeaderFilter();
        providers.add(authorizationHeaderFilter);
        WebClient webClient = WebClient.create((String)serviceAddress, providers);
        WebClients.configureUserAndPassword((WebClient)webClient, (String)this.username, (String)this.password);
        boolean registeredCert = false;
        if (this.trustAllCerts) {
            WebClients.disableSslChecks((WebClient)webClient);
        } else if (this.caCertFile != null || this.caCertData != null) {
            WebClients.configureCaCert((WebClient)webClient, (String)this.caCertData, (File)this.caCertFile);
            registeredCert = true;
        }
        if (!(this.clientCertFile == null && this.clientCertData == null || this.clientKeyFile == null && this.clientKeyData == null)) {
            WebClients.configureClientCert((WebClient)webClient, (String)this.clientCertData, (File)this.clientCertFile, (String)this.clientKeyData, (File)this.clientKeyFile, (String)this.clientKeyAlgo, (char[])this.clientKeyPassword);
            registeredCert = true;
        }
        if (!registeredCert && Strings.isNotBlank((String)(token = this.findOpenShiftToken()))) {
            String authHeader = "Bearer " + token;
            authorizationHeaderFilter.setAuthorizationHeader(authHeader);
        }
        return webClient;
    }

    protected String findOpenShiftToken() {
        File file = KubernetesFactory.getOpenShiftConfigFile();
        String answer = null;
        if (file.exists() && file.isFile()) {
            this.log.debug("Parsing OpenShift configuration: " + file);
            String tokenPrefix = "token:";
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                boolean inUsers = false;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    if (line.startsWith("users:")) {
                        inUsers = true;
                        continue;
                    }
                    char ch = line.charAt(0);
                    if (Character.isWhitespace(ch) || ch == '-') {
                        String token;
                        String text;
                        if (!inUsers || !(text = line.trim()).startsWith(tokenPrefix) || !Strings.isNotBlank((String)(token = text.substring(tokenPrefix.length()).trim()))) continue;
                        answer = token;
                        continue;
                    }
                    inUsers = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Could not parse OpenShift configuration file: " + file);
            }
        }
        return answer;
    }

    public static File getOpenShiftConfigFile() {
        String file = System.getProperty(OPENSHIFT_CONFIG_FILE_PROPERTY);
        if (file != null) {
            return new File(file);
        }
        String homeDir = System.getProperty("user.home", ".");
        return new File(homeDir, ".config/openshift/config");
    }

    protected List<Object> createProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        Annotations[] annotationsToUse = JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS;
        ObjectMapper objectMapper = KubernetesFactory.createObjectMapper();
        providers.add(new JacksonJaxbJsonProvider(objectMapper, annotationsToUse));
        providers.add((Object)new PlainTextJacksonProvider(objectMapper, annotationsToUse));
        providers.add(new ExceptionResponseMapper());
        return providers;
    }

    public String getKubernetesMaster() {
        String answer = this.address;
        int idx = answer.lastIndexOf(":");
        if (idx > 0) {
            answer = answer.substring(0, idx);
        }
        if ((idx = answer.lastIndexOf(":")) > 0) {
            answer = answer.substring(idx + 1);
        }
        if ((idx = answer.lastIndexOf("/")) > 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (Strings.isNullOrBlank((String)address)) {
            this.address = this.findKubernetesMaster();
        }
        if (this.verifyAddress) {
            try {
                URL url = new URL(this.address);
                this.address = KubernetesHelper.isServiceSsl(url.getHost(), url.getPort(), true) ? "https://" + url.getHost() + ":" + url.getPort() : "http://" + url.getHost() + ":" + url.getPort();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid kubernetes master address", e);
            }
        }
    }

    public static String resolveHttpKubernetesMaster() {
        return KubernetesFactory.resolveHttpKubernetesMaster(false);
    }

    public static String resolveHttpKubernetesMaster(boolean writeable) {
        String kubernetesMaster = KubernetesFactory.resolveKubernetesMaster(writeable);
        if (kubernetesMaster.startsWith("tcp:")) {
            return "https:" + kubernetesMaster.substring(4);
        }
        return kubernetesMaster;
    }

    public static String resolveKubernetesMaster() {
        return KubernetesFactory.resolveKubernetesMaster(false);
    }

    public static String resolveKubernetesMaster(boolean writeable) {
        String kubernetesMaster;
        String hostEnvVar = KUBERNETES_RO_SERVICE_HOST_ENV_VAR;
        String portEnvVar = KUBERNETES_RO_SERVICE_PORT_ENV_VAR;
        String proto = "https";
        if (writeable) {
            hostEnvVar = KUBERNETES_SERVICE_HOST_ENV_VAR;
            portEnvVar = KUBERNETES_SERVICE_PORT_ENV_VAR;
        }
        if (Strings.isNullOrBlank((String)(kubernetesMaster = Strings.isNotBlank((String)(kubernetesMaster = System.getenv(hostEnvVar))) ? proto + "://" + kubernetesMaster + ":" + System.getenv(portEnvVar) : System.getenv(KUBERNETES_MASTER_ENV_VAR)))) {
            kubernetesMaster = System.getProperty(KUBERNETES_MASTER_SYSTEM_PROPERTY);
        }
        if (Strings.isNotBlank((String)kubernetesMaster)) {
            return kubernetesMaster;
        }
        return DEFAULT_KUBERNETES_MASTER;
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        Map<String, Class<?>> kindToClasses = KubernetesFactory.getKindToClassMap();
        KubernetesDeserializer deserializer = new KubernetesDeserializer(kindToClasses);
        SimpleModule module = new SimpleModule("Kubernetes");
        module.addDeserializer(Object.class, (JsonDeserializer)deserializer);
        mapper.registerModule((Module)module);
        return mapper;
    }

    protected static Map<String, Class<?>> getKindToClassMap() {
        Map<String, Class<?>> kindToClasses = KindToClassMapping.getKindToClassMap();
        if (!kindToClasses.containsKey("List")) {
            kindToClasses.put("List", KubernetesList.class);
        }
        if (!kindToClasses.containsKey("OAuthClient")) {
            kindToClasses.put("OAuthClient", OAuthClient.class);
        }
        return kindToClasses;
    }

    @Provider
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public static class PlainTextJacksonProvider
    extends JacksonJaxbJsonProvider {
        public PlainTextJacksonProvider(ObjectMapper mapper, Annotations[] annotationsToUse) {
            super(mapper, annotationsToUse);
        }

        protected boolean hasMatchingMediaType(MediaType mediaType) {
            boolean answer = super.hasMatchingMediaType(mediaType);
            String type = mediaType.getType();
            String subtype = mediaType.getSubtype();
            if (!answer && type.equals("text")) {
                answer = super.hasMatchingMediaType(MediaType.APPLICATION_JSON_TYPE);
            }
            return answer;
        }
    }
}

