/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.Map;

public class KubernetesDeserializer
extends StdDeserializer<Object> {
    private final Map<String, Class<?>> kindToClasses;

    public KubernetesDeserializer(Map<String, Class<?>> kindToClasses) {
        super(Object.class);
        this.kindToClasses = kindToClasses;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        TreeNode treeNode = mapper.readTree(jp);
        if (treeNode.isObject()) {
            String kindText;
            Class<?> classForKind;
            ObjectNode root = (ObjectNode)treeNode;
            Object realClass = null;
            JsonNode kind = root.get("kind");
            if (kind != null && (classForKind = this.kindToClasses.get(kindText = kind.textValue())) != null) {
                return mapper.treeToValue((TreeNode)root, classForKind);
            }
        } else {
            ValueNode valueNode = (ValueNode)treeNode;
            if (valueNode.isTextual()) {
                return valueNode.textValue();
            }
            if (valueNode.isNumber()) {
                return valueNode.numberValue();
            }
        }
        return null;
    }
}

