/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ManifestContainer;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "containers", "volumes"})
public class Manifest {
    @JsonProperty(value="version")
    private Version version;
    @JsonProperty(value="containers")
    @Valid
    private List<ManifestContainer> containers = new ArrayList<ManifestContainer>();
    @JsonProperty(value="volumes")
    @JsonDeserialize(as=LinkedHashSet.class)
    @Valid
    private Set<Volume> volumes = new LinkedHashSet<Volume>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="version")
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Version version) {
        this.version = version;
    }

    @JsonProperty(value="containers")
    public List<ManifestContainer> getContainers() {
        return this.containers;
    }

    @JsonProperty(value="containers")
    public void setContainers(List<ManifestContainer> containers) {
        this.containers = containers;
    }

    @JsonProperty(value="volumes")
    public Set<Volume> getVolumes() {
        return this.volumes;
    }

    @JsonProperty(value="volumes")
    public void setVolumes(Set<Volume> volumes) {
        this.volumes = volumes;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public static enum Version {
        V_1_BETA_1("v1beta1"),
        __EMPTY__("");

        private final String value;
        private static Map<String, Version> constants;

        private Version(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Version fromValue(String value) {
            Version constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Version>();
            for (Version c : Version.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

