
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * Manifest describing group of [Docker containers](http://docker.io); also used by [Google Cloud Platform's container-vm images](https://developers.google.com/compute/docs/containers).
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "version",
    "containers",
    "volumes"
})
public class Manifest {

    /**
     * The version of the manifest.
     * 
     */
    @JsonProperty("version")
    private Manifest.Version version;
    /**
     * The list of containers to launch.
     * 
     */
    @JsonProperty("containers")
    @Valid
    private List<ManifestContainer> containers = new ArrayList<ManifestContainer>();
    /**
     * A list of volumes to share between containers.
     * 
     */
    @JsonProperty("volumes")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @Valid
    private Set<Volume> volumes = new LinkedHashSet<Volume>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The version of the manifest.
     * 
     * @return
     *     The version
     */
    @JsonProperty("version")
    public Manifest.Version getVersion() {
        return version;
    }

    /**
     * The version of the manifest.
     * 
     * @param version
     *     The version
     */
    @JsonProperty("version")
    public void setVersion(Manifest.Version version) {
        this.version = version;
    }

    /**
     * The list of containers to launch.
     * 
     * @return
     *     The containers
     */
    @JsonProperty("containers")
    public List<ManifestContainer> getContainers() {
        return containers;
    }

    /**
     * The list of containers to launch.
     * 
     * @param containers
     *     The containers
     */
    @JsonProperty("containers")
    public void setContainers(List<ManifestContainer> containers) {
        this.containers = containers;
    }

    /**
     * A list of volumes to share between containers.
     * 
     * @return
     *     The volumes
     */
    @JsonProperty("volumes")
    public Set<Volume> getVolumes() {
        return volumes;
    }

    /**
     * A list of volumes to share between containers.
     * 
     * @param volumes
     *     The volumes
     */
    @JsonProperty("volumes")
    public void setVolumes(Set<Volume> volumes) {
        this.volumes = volumes;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum Version {

        V_1_BETA_1("v1beta1"),
        __EMPTY__("");
        private final String value;
        private static Map<String, Manifest.Version> constants = new HashMap<String, Manifest.Version>();

        static {
            for (Manifest.Version c: values()) {
                constants.put(c.value, c);
            }
        }

        private Version(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Manifest.Version fromValue(String value) {
            Manifest.Version constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
