
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * The desired configuration of the pod
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "manifest"
})
public class PodTemplateDesiredState {

    /**
     * Manifest describing group of [Docker containers](http://docker.io); also used by [Google Cloud Platform's container-vm images](https://developers.google.com/compute/docs/containers).
     * 
     */
    @JsonProperty("manifest")
    @Valid
    private Manifest manifest;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Manifest describing group of [Docker containers](http://docker.io); also used by [Google Cloud Platform's container-vm images](https://developers.google.com/compute/docs/containers).
     * 
     * @return
     *     The manifest
     */
    @JsonProperty("manifest")
    public Manifest getManifest() {
        return manifest;
    }

    /**
     * Manifest describing group of [Docker containers](http://docker.io); also used by [Google Cloud Platform's container-vm images](https://developers.google.com/compute/docs/containers).
     * 
     * @param manifest
     *     The manifest
     */
    @JsonProperty("manifest")
    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
