
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * The current configuration and status of the pod. Fields in common with desiredState have the same meaning.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "manifest",
    "status",
    "host",
    "podIP",
    "info"
})
public class CurrentState {

    /**
     * 
     */
    @JsonProperty("manifest")
    @Valid
    private PodContainerManifest manifest;
    /**
     * 
     */
    @JsonProperty("status")
    private java.lang.String status;
    /**
     * 
     */
    @JsonProperty("host")
    private java.lang.String host;
    /**
     * 
     */
    @JsonProperty("podIP")
    private java.lang.String podIP;
    /**
     * 
     */
    @JsonProperty("info")
    @Valid
    private Map<String, PodCurrentContainerInfo> info;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * 
     * @return
     *     The manifest
     */
    @JsonProperty("manifest")
    public PodContainerManifest getManifest() {
        return manifest;
    }

    /**
     * 
     * @param manifest
     *     The manifest
     */
    @JsonProperty("manifest")
    public void setManifest(PodContainerManifest manifest) {
        this.manifest = manifest;
    }

    /**
     * 
     * @return
     *     The status
     */
    @JsonProperty("status")
    public java.lang.String getStatus() {
        return status;
    }

    /**
     * 
     * @param status
     *     The status
     */
    @JsonProperty("status")
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

    /**
     * 
     * @return
     *     The host
     */
    @JsonProperty("host")
    public java.lang.String getHost() {
        return host;
    }

    /**
     * 
     * @param host
     *     The host
     */
    @JsonProperty("host")
    public void setHost(java.lang.String host) {
        this.host = host;
    }

    /**
     * 
     * @return
     *     The podIP
     */
    @JsonProperty("podIP")
    public java.lang.String getPodIP() {
        return podIP;
    }

    /**
     * 
     * @param podIP
     *     The podIP
     */
    @JsonProperty("podIP")
    public void setPodIP(java.lang.String podIP) {
        this.podIP = podIP;
    }

    /**
     * 
     * @return
     *     The info
     */
    @JsonProperty("info")
    public Map<String, PodCurrentContainerInfo> getInfo() {
        return info;
    }

    /**
     * 
     * @param info
     *     The info
     */
    @JsonProperty("info")
    public void setInfo(Map<String, PodCurrentContainerInfo> info) {
        this.info = info;
    }

    @Override
    public java.lang.String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
