
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * Returns the current list of services.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "kind",
    "creationTimestamp",
    "resourceVersion",
    "apiVersion",
    "items"
})
public class ServiceListSchema {

    /**
     * 
     */
    @JsonProperty("kind")
    private ServiceListSchema.Kind kind;
    /**
     * 
     */
    @JsonProperty("creationTimestamp")
    private String creationTimestamp;
    /**
     * 
     */
    @JsonProperty("resourceVersion")
    private Integer resourceVersion;
    /**
     * 
     */
    @JsonProperty("apiVersion")
    private ServiceListSchema.ApiVersion apiVersion;
    @JsonProperty("items")
    @Valid
    private List<ServiceSchema> items = new ArrayList<ServiceSchema>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public ServiceListSchema.Kind getKind() {
        return kind;
    }

    /**
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(ServiceListSchema.Kind kind) {
        this.kind = kind;
    }

    /**
     * 
     * @return
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public String getCreationTimestamp() {
        return creationTimestamp;
    }

    /**
     * 
     * @param creationTimestamp
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public void setCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    /**
     * 
     * @return
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public Integer getResourceVersion() {
        return resourceVersion;
    }

    /**
     * 
     * @param resourceVersion
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public void setResourceVersion(Integer resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    /**
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public ServiceListSchema.ApiVersion getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(ServiceListSchema.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * 
     * @return
     *     The items
     */
    @JsonProperty("items")
    public List<ServiceSchema> getItems() {
        return items;
    }

    /**
     * 
     * @param items
     *     The items
     */
    @JsonProperty("items")
    public void setItems(List<ServiceSchema> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum ApiVersion {

        V_1_BETA_1("v1beta1");
        private final String value;
        private static Map<String, ServiceListSchema.ApiVersion> constants = new HashMap<String, ServiceListSchema.ApiVersion>();

        static {
            for (ServiceListSchema.ApiVersion c: values()) {
                constants.put(c.value, c);
            }
        }

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ServiceListSchema.ApiVersion fromValue(String value) {
            ServiceListSchema.ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("org.jsonschema2pojo")
    public static enum Kind {

        SERVICE_LIST("ServiceList");
        private final String value;
        private static Map<String, ServiceListSchema.Kind> constants = new HashMap<String, ServiceListSchema.Kind>();

        static {
            for (ServiceListSchema.Kind c: values()) {
                constants.put(c.value, c);
            }
        }

        private Kind(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ServiceListSchema.Kind fromValue(String value) {
            ServiceListSchema.Kind constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
