
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "command",
    "cpu",
    "env",
    "image",
    "imagePullPolicy",
    "lifecycle",
    "livenessProbe",
    "memory",
    "name",
    "ports",
    "privileged",
    "terminationMessagePath",
    "volumeMounts",
    "workingDir"
})
public class Container {

    @JsonProperty("command")
    @Valid
    private List<String> command = new ArrayList<String>();
    @JsonProperty("cpu")
    private Integer cpu;
    @JsonProperty("env")
    @Valid
    private List<EnvVar> env = new ArrayList<EnvVar>();
    @JsonProperty("image")
    private String image;
    @JsonProperty("imagePullPolicy")
    private String imagePullPolicy;
    @JsonProperty("lifecycle")
    @Valid
    private Lifecycle lifecycle;
    @JsonProperty("livenessProbe")
    @Valid
    private LivenessProbe livenessProbe;
    @JsonProperty("memory")
    private Integer memory;
    @JsonProperty("name")
    private String name;
    @JsonProperty("ports")
    @Valid
    private List<Port> ports = new ArrayList<Port>();
    @JsonProperty("privileged")
    private Boolean privileged;
    @JsonProperty("terminationMessagePath")
    private String terminationMessagePath;
    @JsonProperty("volumeMounts")
    @Valid
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    @JsonProperty("workingDir")
    private String workingDir;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * @return
     *     The command
     */
    @JsonProperty("command")
    public List<String> getCommand() {
        return command;
    }

    /**
     * 
     * @param command
     *     The command
     */
    @JsonProperty("command")
    public void setCommand(List<String> command) {
        this.command = command;
    }

    /**
     * 
     * @return
     *     The cpu
     */
    @JsonProperty("cpu")
    public Integer getCpu() {
        return cpu;
    }

    /**
     * 
     * @param cpu
     *     The cpu
     */
    @JsonProperty("cpu")
    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    /**
     * 
     * @return
     *     The env
     */
    @JsonProperty("env")
    public List<EnvVar> getEnv() {
        return env;
    }

    /**
     * 
     * @param env
     *     The env
     */
    @JsonProperty("env")
    public void setEnv(List<EnvVar> env) {
        this.env = env;
    }

    /**
     * 
     * @return
     *     The image
     */
    @JsonProperty("image")
    public String getImage() {
        return image;
    }

    /**
     * 
     * @param image
     *     The image
     */
    @JsonProperty("image")
    public void setImage(String image) {
        this.image = image;
    }

    /**
     * 
     * @return
     *     The imagePullPolicy
     */
    @JsonProperty("imagePullPolicy")
    public String getImagePullPolicy() {
        return imagePullPolicy;
    }

    /**
     * 
     * @param imagePullPolicy
     *     The imagePullPolicy
     */
    @JsonProperty("imagePullPolicy")
    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    /**
     * 
     * @return
     *     The lifecycle
     */
    @JsonProperty("lifecycle")
    public Lifecycle getLifecycle() {
        return lifecycle;
    }

    /**
     * 
     * @param lifecycle
     *     The lifecycle
     */
    @JsonProperty("lifecycle")
    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    /**
     * 
     * @return
     *     The livenessProbe
     */
    @JsonProperty("livenessProbe")
    public LivenessProbe getLivenessProbe() {
        return livenessProbe;
    }

    /**
     * 
     * @param livenessProbe
     *     The livenessProbe
     */
    @JsonProperty("livenessProbe")
    public void setLivenessProbe(LivenessProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    /**
     * 
     * @return
     *     The memory
     */
    @JsonProperty("memory")
    public Integer getMemory() {
        return memory;
    }

    /**
     * 
     * @param memory
     *     The memory
     */
    @JsonProperty("memory")
    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    /**
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * @return
     *     The ports
     */
    @JsonProperty("ports")
    public List<Port> getPorts() {
        return ports;
    }

    /**
     * 
     * @param ports
     *     The ports
     */
    @JsonProperty("ports")
    public void setPorts(List<Port> ports) {
        this.ports = ports;
    }

    /**
     * 
     * @return
     *     The privileged
     */
    @JsonProperty("privileged")
    public Boolean getPrivileged() {
        return privileged;
    }

    /**
     * 
     * @param privileged
     *     The privileged
     */
    @JsonProperty("privileged")
    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    /**
     * 
     * @return
     *     The terminationMessagePath
     */
    @JsonProperty("terminationMessagePath")
    public String getTerminationMessagePath() {
        return terminationMessagePath;
    }

    /**
     * 
     * @param terminationMessagePath
     *     The terminationMessagePath
     */
    @JsonProperty("terminationMessagePath")
    public void setTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
    }

    /**
     * 
     * @return
     *     The volumeMounts
     */
    @JsonProperty("volumeMounts")
    public List<VolumeMount> getVolumeMounts() {
        return volumeMounts;
    }

    /**
     * 
     * @param volumeMounts
     *     The volumeMounts
     */
    @JsonProperty("volumeMounts")
    public void setVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    /**
     * 
     * @return
     *     The workingDir
     */
    @JsonProperty("workingDir")
    public String getWorkingDir() {
        return workingDir;
    }

    /**
     * 
     * @param workingDir
     *     The workingDir
     */
    @JsonProperty("workingDir")
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
