
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "name",
    "containerPort",
    "hostPort",
    "protocol"
})
public class Port {

    /**
     * A symbolic name used to create and track the port. Must be an RFC1035 compatible value (a single segment of a DNS name).
     * 
     */
    @JsonProperty("name")
    private String name;
    /**
     * The port on which the container is listening.
     * 
     */
    @JsonProperty("containerPort")
    private Integer containerPort;
    /**
     * The port on the host which maps to the containerPort. Default is auto-allocated.
     * 
     */
    @JsonProperty("hostPort")
    private Integer hostPort;
    /**
     * The protocol for this port. Valid options are TCP and UDP. Default is TCP.
     * 
     */
    @JsonProperty("protocol")
    private String protocol;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * A symbolic name used to create and track the port. Must be an RFC1035 compatible value (a single segment of a DNS name).
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * A symbolic name used to create and track the port. Must be an RFC1035 compatible value (a single segment of a DNS name).
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * The port on which the container is listening.
     * 
     * @return
     *     The containerPort
     */
    @JsonProperty("containerPort")
    public Integer getContainerPort() {
        return containerPort;
    }

    /**
     * The port on which the container is listening.
     * 
     * @param containerPort
     *     The containerPort
     */
    @JsonProperty("containerPort")
    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    /**
     * The port on the host which maps to the containerPort. Default is auto-allocated.
     * 
     * @return
     *     The hostPort
     */
    @JsonProperty("hostPort")
    public Integer getHostPort() {
        return hostPort;
    }

    /**
     * The port on the host which maps to the containerPort. Default is auto-allocated.
     * 
     * @param hostPort
     *     The hostPort
     */
    @JsonProperty("hostPort")
    public void setHostPort(Integer hostPort) {
        this.hostPort = hostPort;
    }

    /**
     * The protocol for this port. Valid options are TCP and UDP. Default is TCP.
     * 
     * @return
     *     The protocol
     */
    @JsonProperty("protocol")
    public String getProtocol() {
        return protocol;
    }

    /**
     * The protocol for this port. Valid options are TCP and UDP. Default is TCP.
     * 
     * @param protocol
     *     The protocol
     */
    @JsonProperty("protocol")
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
