
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * Returns the current list of controllers.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "kind",
    "creationTimestamp",
    "resourceVersion",
    "apiVersion",
    "items"
})
public class ReplicationControllerListSchema {

    /**
     * 
     */
    @JsonProperty("kind")
    private ReplicationControllerListSchema.Kind kind;
    /**
     * 
     */
    @JsonProperty("creationTimestamp")
    private String creationTimestamp;
    /**
     * 
     */
    @JsonProperty("resourceVersion")
    private Integer resourceVersion;
    /**
     * 
     */
    @JsonProperty("apiVersion")
    private ReplicationControllerListSchema.ApiVersion apiVersion;
    @JsonProperty("items")
    @Valid
    private List<ReplicationControllerSchema> items = new ArrayList<ReplicationControllerSchema>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public ReplicationControllerListSchema.Kind getKind() {
        return kind;
    }

    /**
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(ReplicationControllerListSchema.Kind kind) {
        this.kind = kind;
    }

    /**
     * 
     * @return
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public String getCreationTimestamp() {
        return creationTimestamp;
    }

    /**
     * 
     * @param creationTimestamp
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public void setCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    /**
     * 
     * @return
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public Integer getResourceVersion() {
        return resourceVersion;
    }

    /**
     * 
     * @param resourceVersion
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public void setResourceVersion(Integer resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    /**
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public ReplicationControllerListSchema.ApiVersion getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(ReplicationControllerListSchema.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * 
     * @return
     *     The items
     */
    @JsonProperty("items")
    public List<ReplicationControllerSchema> getItems() {
        return items;
    }

    /**
     * 
     * @param items
     *     The items
     */
    @JsonProperty("items")
    public void setItems(List<ReplicationControllerSchema> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum ApiVersion {

        __EMPTY__(""),
        V_1_BETA_1("v1beta1"),
        V_1_BETA_2("v1beta2"),
        V_1_BETA_3("v1beta3");
        private final String value;
        private static Map<String, ReplicationControllerListSchema.ApiVersion> constants = new HashMap<String, ReplicationControllerListSchema.ApiVersion>();

        static {
            for (ReplicationControllerListSchema.ApiVersion c: values()) {
                constants.put(c.value, c);
            }
        }

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ReplicationControllerListSchema.ApiVersion fromValue(String value) {
            ReplicationControllerListSchema.ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("org.jsonschema2pojo")
    public static enum Kind {

        REPLICATION_CONTROLLER_LIST("ReplicationControllerList");
        private final String value;
        private static Map<String, ReplicationControllerListSchema.Kind> constants = new HashMap<String, ReplicationControllerListSchema.Kind>();

        static {
            for (ReplicationControllerListSchema.Kind c: values()) {
                constants.put(c.value, c);
            }
        }

        private Kind(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ReplicationControllerListSchema.Kind fromValue(String value) {
            ReplicationControllerListSchema.Kind constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
