
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "name",
    "image",
    "imagePullPolicy",
    "command",
    "workingDir",
    "volumeMounts",
    "ports",
    "env"
})
public class ManifestContainer {

    /**
     * A symbolic name used to create and track the container. Must be an RFC1035 compatible value (a single segment of a DNS name). All containers must have unique names.
     * 
     */
    @JsonProperty("name")
    private String name;
    /**
     * The container image to run.
     * 
     */
    @JsonProperty("image")
    private String image;
    /**
     * Policy for pulling images for this container.
     * 
     */
    @JsonProperty("imagePullPolicy")
    private PullPolicy imagePullPolicy;
    /**
     * The command line to run. If this is omitted, the container is assumed to have a command embedded in it.
     * 
     */
    @JsonProperty("command")
    @Valid
    private List<String> command = new ArrayList<String>();
    /**
     * The initial working directory for the command. Default is the container’s embedded working directory or else the Docker default.
     * 
     */
    @JsonProperty("workingDir")
    private String workingDir;
    /**
     * Data volumes to expose into the container.
     * 
     */
    @JsonProperty("volumeMounts")
    @Valid
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    /**
     * Ports to expose from the container. All of these are exposed out through the public interface of the VM.
     * 
     */
    @JsonProperty("ports")
    @Valid
    private List<Port> ports = new ArrayList<Port>();
    /**
     * Environment variables to set before the container runs.
     * 
     */
    @JsonProperty("env")
    @Valid
    private List<Env> env = new ArrayList<Env>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * A symbolic name used to create and track the container. Must be an RFC1035 compatible value (a single segment of a DNS name). All containers must have unique names.
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * A symbolic name used to create and track the container. Must be an RFC1035 compatible value (a single segment of a DNS name). All containers must have unique names.
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * The container image to run.
     * 
     * @return
     *     The image
     */
    @JsonProperty("image")
    public String getImage() {
        return image;
    }

    /**
     * The container image to run.
     * 
     * @param image
     *     The image
     */
    @JsonProperty("image")
    public void setImage(String image) {
        this.image = image;
    }

    /**
     * Policy for pulling images for this container.
     * 
     * @return
     *     The imagePullPolicy
     */
    @JsonProperty("imagePullPolicy")
    public PullPolicy getImagePullPolicy() {
        return imagePullPolicy;
    }

    /**
     * Policy for pulling images for this container.
     * 
     * @param imagePullPolicy
     *     The imagePullPolicy
     */
    @JsonProperty("imagePullPolicy")
    public void setImagePullPolicy(PullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    /**
     * The command line to run. If this is omitted, the container is assumed to have a command embedded in it.
     * 
     * @return
     *     The command
     */
    @JsonProperty("command")
    public List<String> getCommand() {
        return command;
    }

    /**
     * The command line to run. If this is omitted, the container is assumed to have a command embedded in it.
     * 
     * @param command
     *     The command
     */
    @JsonProperty("command")
    public void setCommand(List<String> command) {
        this.command = command;
    }

    /**
     * The initial working directory for the command. Default is the container’s embedded working directory or else the Docker default.
     * 
     * @return
     *     The workingDir
     */
    @JsonProperty("workingDir")
    public String getWorkingDir() {
        return workingDir;
    }

    /**
     * The initial working directory for the command. Default is the container’s embedded working directory or else the Docker default.
     * 
     * @param workingDir
     *     The workingDir
     */
    @JsonProperty("workingDir")
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    /**
     * Data volumes to expose into the container.
     * 
     * @return
     *     The volumeMounts
     */
    @JsonProperty("volumeMounts")
    public List<VolumeMount> getVolumeMounts() {
        return volumeMounts;
    }

    /**
     * Data volumes to expose into the container.
     * 
     * @param volumeMounts
     *     The volumeMounts
     */
    @JsonProperty("volumeMounts")
    public void setVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    /**
     * Ports to expose from the container. All of these are exposed out through the public interface of the VM.
     * 
     * @return
     *     The ports
     */
    @JsonProperty("ports")
    public List<Port> getPorts() {
        return ports;
    }

    /**
     * Ports to expose from the container. All of these are exposed out through the public interface of the VM.
     * 
     * @param ports
     *     The ports
     */
    @JsonProperty("ports")
    public void setPorts(List<Port> ports) {
        this.ports = ports;
    }

    /**
     * Environment variables to set before the container runs.
     * 
     * @return
     *     The env
     */
    @JsonProperty("env")
    public List<Env> getEnv() {
        return env;
    }

    /**
     * Environment variables to set before the container runs.
     * 
     * @param env
     *     The env
     */
    @JsonProperty("env")
    public void setEnv(List<Env> env) {
        this.env = env;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
