
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * The desired configuration of the replicationController
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "replicas",
    "replicaSelector",
    "podTemplate"
})
public class ControllerDesiredState {

    /**
     * Number of pods desired in the set
     * 
     */
    @JsonProperty("replicas")
    private Integer replicas;
    /**
     * Required labels used to identify pods in the set
     * 
     */
    @JsonProperty("replicaSelector")
    @Valid
    private Map<String, String> replicaSelector;
    /**
     * Template from which to create new pods, as necessary. Identical to pod schema.
     * 
     */
    @JsonProperty("podTemplate")
    @Valid
    private PodTemplate podTemplate;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * Number of pods desired in the set
     * 
     * @return
     *     The replicas
     */
    @JsonProperty("replicas")
    public Integer getReplicas() {
        return replicas;
    }

    /**
     * Number of pods desired in the set
     * 
     * @param replicas
     *     The replicas
     */
    @JsonProperty("replicas")
    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    /**
     * Required labels used to identify pods in the set
     * 
     * @return
     *     The replicaSelector
     */
    @JsonProperty("replicaSelector")
    public Map<String, String> getReplicaSelector() {
        return replicaSelector;
    }

    /**
     * Required labels used to identify pods in the set
     * 
     * @param replicaSelector
     *     The replicaSelector
     */
    @JsonProperty("replicaSelector")
    public void setReplicaSelector(Map<String, String> replicaSelector) {
        this.replicaSelector = replicaSelector;
    }

    /**
     * Template from which to create new pods, as necessary. Identical to pod schema.
     * 
     * @return
     *     The podTemplate
     */
    @JsonProperty("podTemplate")
    public PodTemplate getPodTemplate() {
        return podTemplate;
    }

    /**
     * Template from which to create new pods, as necessary. Identical to pod schema.
     * 
     * @param podTemplate
     *     The podTemplate
     */
    @JsonProperty("podTemplate")
    public void setPodTemplate(PodTemplate podTemplate) {
        this.podTemplate = podTemplate;
    }

    @Override
    public java.lang.String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
