
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * The current state of the replicationController
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "replicas",
    "podTemplate"
})
public class ControllerCurrentState {

    /**
     * Number of pods currently in the set
     * 
     */
    @JsonProperty("replicas")
    private Integer replicas;
    /**
     * Template from which to create new pods, as necessary. Identical to pod schema.
     * 
     */
    @JsonProperty("podTemplate")
    @Valid
    private PodTemplate_ podTemplate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Number of pods currently in the set
     * 
     * @return
     *     The replicas
     */
    @JsonProperty("replicas")
    public Integer getReplicas() {
        return replicas;
    }

    /**
     * Number of pods currently in the set
     * 
     * @param replicas
     *     The replicas
     */
    @JsonProperty("replicas")
    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    /**
     * Template from which to create new pods, as necessary. Identical to pod schema.
     * 
     * @return
     *     The podTemplate
     */
    @JsonProperty("podTemplate")
    public PodTemplate_ getPodTemplate() {
        return podTemplate;
    }

    /**
     * Template from which to create new pods, as necessary. Identical to pod schema.
     * 
     * @param podTemplate
     *     The podTemplate
     */
    @JsonProperty("podTemplate")
    public void setPodTemplate(PodTemplate_ podTemplate) {
        this.podTemplate = podTemplate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
