
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * A replicationController resource. A replicationController helps to create and manage a set of pods. It acts as a factory to create new pods based on a template. It ensures that there are a specific number of pods running. If fewer pods are running than `replicas` then the needed pods are generated using `podTemplate`. If more pods are running than `replicas`, then excess pods are deleted.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "kind",
    "id",
    "creationTimestamp",
    "selfLink",
    "desiredState",
    "currentState",
    "labels"
})
public class ReplicationControllerSchema {

    /**
     * 
     */
    @JsonProperty("kind")
    private java.lang.String kind;
    /**
     * 
     */
    @JsonProperty("id")
    private java.lang.String id;
    /**
     * 
     */
    @JsonProperty("creationTimestamp")
    private java.lang.String creationTimestamp;
    /**
     * 
     */
    @JsonProperty("selfLink")
    private java.lang.String selfLink;
    /**
     * The desired configuration of the replicationController
     * 
     */
    @JsonProperty("desiredState")
    @Valid
    private ControllerDesiredState desiredState;
    /**
     * The current state of the replicationController
     * 
     */
    @JsonProperty("currentState")
    @Valid
    private ControllerCurrentState currentState;
    /**
     * 
     */
    @JsonProperty("labels")
    @Valid
    private Map<String, String> labels;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public java.lang.String getKind() {
        return kind;
    }

    /**
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(java.lang.String kind) {
        this.kind = kind;
    }

    /**
     * 
     * @return
     *     The id
     */
    @JsonProperty("id")
    public java.lang.String getId() {
        return id;
    }

    /**
     * 
     * @param id
     *     The id
     */
    @JsonProperty("id")
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * 
     * @return
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public java.lang.String getCreationTimestamp() {
        return creationTimestamp;
    }

    /**
     * 
     * @param creationTimestamp
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public void setCreationTimestamp(java.lang.String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    /**
     * 
     * @return
     *     The selfLink
     */
    @JsonProperty("selfLink")
    public java.lang.String getSelfLink() {
        return selfLink;
    }

    /**
     * 
     * @param selfLink
     *     The selfLink
     */
    @JsonProperty("selfLink")
    public void setSelfLink(java.lang.String selfLink) {
        this.selfLink = selfLink;
    }

    /**
     * The desired configuration of the replicationController
     * 
     * @return
     *     The desiredState
     */
    @JsonProperty("desiredState")
    public ControllerDesiredState getDesiredState() {
        return desiredState;
    }

    /**
     * The desired configuration of the replicationController
     * 
     * @param desiredState
     *     The desiredState
     */
    @JsonProperty("desiredState")
    public void setDesiredState(ControllerDesiredState desiredState) {
        this.desiredState = desiredState;
    }

    /**
     * The current state of the replicationController
     * 
     * @return
     *     The currentState
     */
    @JsonProperty("currentState")
    public ControllerCurrentState getCurrentState() {
        return currentState;
    }

    /**
     * The current state of the replicationController
     * 
     * @param currentState
     *     The currentState
     */
    @JsonProperty("currentState")
    public void setCurrentState(ControllerCurrentState currentState) {
        this.currentState = currentState;
    }

    /**
     * 
     * @return
     *     The labels
     */
    @JsonProperty("labels")
    public Map<String, String> getLabels() {
        return labels;
    }

    /**
     * 
     * @param labels
     *     The labels
     */
    @JsonProperty("labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @Override
    public java.lang.String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
