
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * Pod resource. A pod corresponds to a co-located group of [Docker containers](http://docker.io).
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "kind",
    "id",
    "creationTimestamp",
    "selfLink",
    "desiredState",
    "currentState",
    "labels"
})
public class PodSchema {

    /**
     * 
     */
    @JsonProperty("kind")
    private java.lang.String kind;
    /**
     * 
     */
    @JsonProperty("id")
    private java.lang.String id;
    /**
     * 
     */
    @JsonProperty("creationTimestamp")
    private java.lang.String creationTimestamp;
    /**
     * 
     */
    @JsonProperty("selfLink")
    private java.lang.String selfLink;
    /**
     * The desired configuration of the pod
     * 
     */
    @JsonProperty("desiredState")
    @Valid
    private DesiredState desiredState;
    /**
     * The current configuration and status of the pod. Fields in common with desiredState have the same meaning.
     * 
     */
    @JsonProperty("currentState")
    @Valid
    private CurrentState currentState;
    /**
     * 
     */
    @JsonProperty("labels")
    @Valid
    private Map<String, String> labels;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public java.lang.String getKind() {
        return kind;
    }

    /**
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(java.lang.String kind) {
        this.kind = kind;
    }

    /**
     * 
     * @return
     *     The id
     */
    @JsonProperty("id")
    public java.lang.String getId() {
        return id;
    }

    /**
     * 
     * @param id
     *     The id
     */
    @JsonProperty("id")
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * 
     * @return
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public java.lang.String getCreationTimestamp() {
        return creationTimestamp;
    }

    /**
     * 
     * @param creationTimestamp
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public void setCreationTimestamp(java.lang.String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    /**
     * 
     * @return
     *     The selfLink
     */
    @JsonProperty("selfLink")
    public java.lang.String getSelfLink() {
        return selfLink;
    }

    /**
     * 
     * @param selfLink
     *     The selfLink
     */
    @JsonProperty("selfLink")
    public void setSelfLink(java.lang.String selfLink) {
        this.selfLink = selfLink;
    }

    /**
     * The desired configuration of the pod
     * 
     * @return
     *     The desiredState
     */
    @JsonProperty("desiredState")
    public DesiredState getDesiredState() {
        return desiredState;
    }

    /**
     * The desired configuration of the pod
     * 
     * @param desiredState
     *     The desiredState
     */
    @JsonProperty("desiredState")
    public void setDesiredState(DesiredState desiredState) {
        this.desiredState = desiredState;
    }

    /**
     * The current configuration and status of the pod. Fields in common with desiredState have the same meaning.
     * 
     * @return
     *     The currentState
     */
    @JsonProperty("currentState")
    public CurrentState getCurrentState() {
        return currentState;
    }

    /**
     * The current configuration and status of the pod. Fields in common with desiredState have the same meaning.
     * 
     * @param currentState
     *     The currentState
     */
    @JsonProperty("currentState")
    public void setCurrentState(CurrentState currentState) {
        this.currentState = currentState;
    }

    /**
     * 
     * @return
     *     The labels
     */
    @JsonProperty("labels")
    public Map<String, String> getLabels() {
        return labels;
    }

    /**
     * 
     * @param labels
     *     The labels
     */
    @JsonProperty("labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @Override
    public java.lang.String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
