/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import org.springframework.boot.loader.jar.AsciiBytes;
import org.springframework.boot.loader.jar.JarEntry;
import org.springframework.boot.loader.jar.JarFile;

class JarURLConnection
extends java.net.JarURLConnection {
    private static final FileNotFoundException FILE_NOT_FOUND_EXCEPTION = new FileNotFoundException();
    private static final String SEPARATOR = "!/";
    private static final URL EMPTY_JAR_URL;
    private static final JarEntryName EMPTY_JAR_ENTRY_NAME;
    private static ThreadLocal<Boolean> useFastExceptions;
    private final JarFile jarFile;
    private URL jarFileUrl;
    private final JarEntryName jarEntryName;
    private JarEntry jarEntry;

    protected JarURLConnection(URL url, JarFile jarFile) throws IOException {
        super(EMPTY_JAR_URL);
        int separator;
        this.url = url;
        String spec = url.getFile().substring(jarFile.getUrl().getFile().length());
        while ((separator = spec.indexOf(SEPARATOR)) > 0) {
            jarFile = this.getNestedJarFile(jarFile, spec.substring(0, separator));
            spec = spec.substring(separator + SEPARATOR.length());
        }
        this.jarFile = jarFile;
        this.jarEntryName = this.getJarEntryName(spec);
    }

    private JarFile getNestedJarFile(JarFile jarFile, String name) throws IOException {
        JarEntry jarEntry = jarFile.getJarEntry(name);
        if (jarEntry == null) {
            this.throwFileNotFound(jarEntry, jarFile);
        }
        return jarFile.getNestedJarFile(jarEntry);
    }

    private JarEntryName getJarEntryName(String spec) {
        if (spec.length() == 0) {
            return EMPTY_JAR_ENTRY_NAME;
        }
        return new JarEntryName(spec);
    }

    @Override
    public void connect() throws IOException {
        if (!this.jarEntryName.isEmpty() && this.jarEntry == null) {
            this.jarEntry = this.jarFile.getJarEntry(this.getEntryName());
            if (this.jarEntry == null) {
                this.throwFileNotFound(this.jarEntryName, this.jarFile);
            }
        }
        this.connected = true;
    }

    private void throwFileNotFound(Object entry, JarFile jarFile) throws FileNotFoundException {
        if (Boolean.TRUE.equals(useFastExceptions.get())) {
            throw FILE_NOT_FOUND_EXCEPTION;
        }
        throw new FileNotFoundException("JAR entry " + entry + " not found in " + jarFile.getName());
    }

    @Override
    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    @Override
    public URL getJarFileURL() {
        if (this.jarFileUrl == null) {
            this.jarFileUrl = this.buildJarFileUrl();
        }
        return this.jarFileUrl;
    }

    private URL buildJarFileUrl() {
        try {
            String spec = this.jarFile.getUrl().getFile();
            if (spec.endsWith(SEPARATOR)) {
                spec = spec.substring(0, spec.length() - SEPARATOR.length());
            }
            if (spec.indexOf(SEPARATOR) == -1) {
                return new URL(spec);
            }
            return new URL("jar:" + spec);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        if (this.jarEntryName.isEmpty()) {
            return null;
        }
        this.connect();
        return this.jarEntry;
    }

    @Override
    public String getEntryName() {
        return this.jarEntryName.toString();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.jarEntryName.isEmpty()) {
            throw new IOException("no entry name specified");
        }
        this.connect();
        InputStream inputStream = this.jarFile.getInputStream(this.jarEntry);
        if (inputStream == null) {
            this.throwFileNotFound(this.jarEntryName, this.jarFile);
        }
        return inputStream;
    }

    @Override
    public int getContentLength() {
        try {
            if (this.jarEntryName.isEmpty()) {
                return this.jarFile.size();
            }
            JarEntry entry = this.getJarEntry();
            return entry == null ? -1 : (int)entry.getSize();
        }
        catch (IOException ex) {
            return -1;
        }
    }

    @Override
    public Object getContent() throws IOException {
        this.connect();
        return this.jarEntryName.isEmpty() ? this.jarFile : super.getContent();
    }

    @Override
    public String getContentType() {
        return this.jarEntryName.getContentType();
    }

    static void setUseFastExceptions(boolean useFastExceptions) {
        JarURLConnection.useFastExceptions.set(useFastExceptions);
    }

    static {
        try {
            EMPTY_JAR_URL = new URL("jar:", null, 0, "file:!/", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return null;
                }
            });
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        EMPTY_JAR_ENTRY_NAME = new JarEntryName("");
        useFastExceptions = new ThreadLocal();
    }

    static class JarEntryName {
        private final String name;
        private String contentType;

        JarEntryName(String spec) {
            this.name = this.decode(spec);
        }

        private String decode(String source) {
            int length;
            int n = length = source == null ? 0 : source.length();
            if (length == 0 || source.indexOf(37) < 0) {
                return new AsciiBytes(source).toString();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
            this.write(source, bos);
            return new AsciiBytes(bos.toByteArray()).toString();
        }

        private void write(String source, ByteArrayOutputStream outputStream) {
            int length = source.length();
            for (int i = 0; i < length; ++i) {
                char c = source.charAt(i);
                if (c > '\u007f') {
                    try {
                        String encoded = URLEncoder.encode(String.valueOf(c), "UTF-8");
                        this.write(encoded, outputStream);
                        continue;
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                if (c == '%') {
                    if (i + 2 >= length) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    c = this.decodeEscapeSequence(source, i);
                    i += 2;
                }
                outputStream.write(c);
            }
        }

        private char decodeEscapeSequence(String source, int i) {
            int hi = Character.digit(source.charAt(i + 1), 16);
            int lo = Character.digit(source.charAt(i + 2), 16);
            if (hi == -1 || lo == -1) {
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            return (char)((hi << 4) + lo);
        }

        public String toString() {
            return this.name;
        }

        public boolean isEmpty() {
            return this.name.length() == 0;
        }

        public String getContentType() {
            if (this.contentType == null) {
                this.contentType = this.deduceContentType();
            }
            return this.contentType;
        }

        private String deduceContentType() {
            String type = this.isEmpty() ? "x-java/jar" : null;
            type = type != null ? type : URLConnection.guessContentTypeFromName(this.toString());
            type = type != null ? type : "content/unknown";
            return type;
        }
    }
}

