/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.springframework.boot.loader.data.RandomAccessData;
import org.springframework.boot.loader.jar.AsciiBytes;
import org.springframework.boot.loader.jar.Bytes;
import org.springframework.boot.loader.jar.FileHeader;

final class CentralDirectoryFileHeader
implements FileHeader {
    private static final AsciiBytes SLASH = new AsciiBytes("/");
    private final byte[] header;
    private AsciiBytes name;
    private final byte[] extra;
    private final AsciiBytes comment;
    private final long localHeaderOffset;

    CentralDirectoryFileHeader(byte[] header, InputStream inputStream) throws IOException {
        this.header = header;
        long nameLength = Bytes.littleEndianValue(header, 28, 2);
        long extraLength = Bytes.littleEndianValue(header, 30, 2);
        long commentLength = Bytes.littleEndianValue(header, 32, 2);
        this.name = new AsciiBytes(Bytes.get(inputStream, nameLength));
        this.extra = Bytes.get(inputStream, extraLength);
        this.comment = new AsciiBytes(Bytes.get(inputStream, commentLength));
        this.localHeaderOffset = Bytes.littleEndianValue(header, 42, 4);
    }

    public AsciiBytes getName() {
        return this.name;
    }

    @Override
    public boolean hasName(String name, String suffix) {
        return this.name.equals(new AsciiBytes(suffix == null ? name : name + suffix));
    }

    public boolean isDirectory() {
        return this.name.endsWith(SLASH);
    }

    @Override
    public int getMethod() {
        return (int)Bytes.littleEndianValue(this.header, 10, 2);
    }

    public long getTime() {
        long date = Bytes.littleEndianValue(this.header, 14, 2);
        long time = Bytes.littleEndianValue(this.header, 12, 2);
        return this.decodeMsDosFormatDateTime(date, time).getTimeInMillis();
    }

    private Calendar decodeMsDosFormatDateTime(long date, long time) {
        int year = (int)(date >> 9 & 0x7FL) + 1980;
        int month = (int)(date >> 5 & 0xFL) - 1;
        int day = (int)(date & 0x1FL);
        int hours = (int)(time >> 11 & 0x1FL);
        int minutes = (int)(time >> 5 & 0x3FL);
        int seconds = (int)(time << 1 & 0x3EL);
        return new GregorianCalendar(year, month, day, hours, minutes, seconds);
    }

    public long getCrc() {
        return Bytes.littleEndianValue(this.header, 16, 4);
    }

    @Override
    public long getCompressedSize() {
        return Bytes.littleEndianValue(this.header, 20, 4);
    }

    @Override
    public long getSize() {
        return Bytes.littleEndianValue(this.header, 24, 4);
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public AsciiBytes getComment() {
        return this.comment;
    }

    @Override
    public long getLocalHeaderOffset() {
        return this.localHeaderOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CentralDirectoryFileHeader fromRandomAccessData(RandomAccessData data, int offset) throws IOException {
        InputStream inputStream = data.getSubsection(offset, data.getSize() - (long)offset).getInputStream(RandomAccessData.ResourceAccess.ONCE);
        try {
            CentralDirectoryFileHeader centralDirectoryFileHeader = CentralDirectoryFileHeader.fromInputStream(inputStream);
            return centralDirectoryFileHeader;
        }
        finally {
            inputStream.close();
        }
    }

    static CentralDirectoryFileHeader fromInputStream(InputStream inputStream) throws IOException {
        byte[] header = new byte[46];
        if (!Bytes.fill(inputStream, header)) {
            return null;
        }
        return new CentralDirectoryFileHeader(header, inputStream);
    }
}

