/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import org.springframework.boot.loader.jar.Handler;
import org.springframework.boot.loader.jar.JarFile;

public class LaunchedURLClassLoader
extends URLClassLoader {
    public LaunchedURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public URL findResource(String name) {
        Handler.setUseFastConnectionExceptions(true);
        try {
            URL uRL = super.findResource(name);
            return uRL;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Handler.setUseFastConnectionExceptions(true);
        try {
            Enumeration<URL> enumeration = super.findResources(name);
            return enumeration;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Handler.setUseFastConnectionExceptions(true);
        try {
            this.definePackageIfNecessary(name);
            Class<?> clazz = super.loadClass(name, resolve);
            return clazz;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    private void definePackageIfNecessary(String className) {
        String packageName;
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0 && this.getPackage(packageName = className.substring(0, lastDot)) == null) {
            this.definePackage(packageName);
        }
    }

    private void definePackage(final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws ClassNotFoundException {
                    String packageEntryName = packageName.replace(".", "/") + "/";
                    for (URL url : LaunchedURLClassLoader.this.getURLs()) {
                        try {
                            JarFile jarFile;
                            if (!(url.getContent() instanceof JarFile) || (jarFile = (JarFile)url.getContent()).getEntry(packageEntryName) == null || jarFile.getManifest() == null) continue;
                            LaunchedURLClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                            return null;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public void clearCache() {
        for (URL url : this.getURLs()) {
            try {
                URLConnection connection = url.openConnection();
                if (!(connection instanceof JarURLConnection)) continue;
                this.clearCache(connection);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void clearCache(URLConnection connection) throws IOException {
        java.util.jar.JarFile jarFile = ((JarURLConnection)connection).getJarFile();
        if (jarFile instanceof JarFile) {
            ((JarFile)jarFile).clearCache();
        }
    }
}

