/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest.binary.repo;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubeapitest.KubeAPITestException;
import io.fabric8.kubeapitest.binary.OSInfo;
import io.fabric8.kubeapitest.binary.repo.ArchiveDescriptor;
import io.fabric8.kubeapitest.binary.repo.BinaryIndex;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryRepo {
    private static final Logger log = LoggerFactory.getLogger(BinaryRepo.class);
    private static final String BINARY_INDEX_URL = "https://raw.githubusercontent.com/kubernetes-sigs/controller-tools/HEAD/envtest-releases.yaml";
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    public static final String TAR_GZ_SUFFIX = ".tar.gz";
    private static List<ArchiveDescriptor> objectNames;
    private final OSInfo osInfo;

    public BinaryRepo(OSInfo osInfo) {
        this.osInfo = osInfo;
    }

    public synchronized Stream<ArchiveDescriptor> listObjectNames() {
        try {
            if (objectNames == null) {
                BinaryIndex index = (BinaryIndex)MAPPER.readValue(new URL(BINARY_INDEX_URL), BinaryIndex.class);
                objectNames = index.getReleases().values().stream().flatMap(v -> v.values().stream()).map(a -> BinaryRepo.mapSelfLinkToArchiveDescriptor(a.getSelfLink())).collect(Collectors.toList());
            }
            return objectNames.stream();
        }
        catch (IOException e) {
            throw new KubeAPITestException(e);
        }
    }

    static ArchiveDescriptor mapSelfLinkToArchiveDescriptor(String selfLink) {
        String[] versionOsArch = selfLink.split("/")[8].replace("envtest-v", "").replace(TAR_GZ_SUFFIX, "").split("-");
        return new ArchiveDescriptor(versionOsArch[0], versionOsArch[2], versionOsArch[1]);
    }

    public File downloadVersionToTempFile(String version) {
        try {
            String url = "https://github.com/kubernetes-sigs/controller-tools/releases/download/envtest-v" + version + "/envtest-v" + version + "-" + this.osInfo.getOSName() + "-" + this.osInfo.getOSArch() + TAR_GZ_SUFFIX;
            File tempFile = File.createTempFile("kubebuilder-tools-" + version, TAR_GZ_SUFFIX);
            log.debug("Downloading binary from url: {} to Temp file: {}", (Object)url, (Object)tempFile.getPath());
            this.copyURLToFile(url, tempFile);
            return tempFile;
        }
        catch (IOException e) {
            throw new KubeAPITestException(e);
        }
    }

    private void copyURLToFile(String url, File tempFile) throws IOException {
        try (InputStream in = new URL(url).openStream();){
            Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

